/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.plan.MapKeysInfo;
import org.apache.pig.impl.util.Pair;

public class RequiredFields {
    private boolean mNeedAllFields = false;
    private boolean mNeedNoFields = false;
    private List<Pair<Integer, Integer>> mFields;
    private List<MapKeysInfo> mMapKeysInfoList;

    public RequiredFields(boolean needAllFields) {
        this(null, needAllFields, false);
    }

    public RequiredFields(boolean needAllFields, boolean needNoFields) {
        this(null, needAllFields, needNoFields);
    }

    public RequiredFields(List<Pair<Integer, Integer>> fields) {
        this(fields, false, false);
    }

    private RequiredFields(List<Pair<Integer, Integer>> fields, boolean needAllFields, boolean needNoFields) {
        this.mFields = fields;
        if (needAllFields && needNoFields) {
            this.mNeedAllFields = false;
            this.mNeedNoFields = false;
        } else {
            this.mNeedAllFields = needAllFields;
            this.mNeedNoFields = needNoFields;
        }
        if (this.mFields != null) {
            this.mMapKeysInfoList = new ArrayList<MapKeysInfo>();
            for (int i = 0; i < this.mFields.size(); ++i) {
                this.mMapKeysInfoList.add(null);
            }
        }
    }

    public List<Pair<Integer, Integer>> getFields() {
        return this.mFields;
    }

    public Pair<Integer, Integer> getField(int i) {
        return this.mFields.get(i);
    }

    public int size() {
        if (this.mFields == null) {
            return 0;
        }
        return this.mFields.size();
    }

    public void setFields(List<Pair<Integer, Integer>> fields) {
        this.mFields = fields;
        if (this.mFields != null) {
            this.mMapKeysInfoList = new ArrayList<MapKeysInfo>();
            for (int i = 0; i < this.mFields.size(); ++i) {
                this.mMapKeysInfoList.add(null);
            }
        }
    }

    public boolean needAllFields() {
        return this.getNeedAllFields();
    }

    public boolean getNeedAllFields() {
        return this.mNeedAllFields;
    }

    public void setNeedAllFields(boolean needAllFields) {
        if (needAllFields && this.needNoFields()) {
            return;
        }
        this.mNeedAllFields = needAllFields;
    }

    public boolean needNoFields() {
        return this.getNeedNoFields();
    }

    public boolean getNeedNoFields() {
        return this.mNeedNoFields;
    }

    public void setNeedNoFields(boolean needNoFields) {
        if (needNoFields && this.needAllFields()) {
            return;
        }
        this.mNeedNoFields = needNoFields;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("needAllFields: " + this.mNeedAllFields);
        sb.append(" needNoFields: " + this.mNeedNoFields);
        sb.append(" fields: " + this.mFields);
        return sb.toString();
    }

    public void merge(RequiredFields r2) {
        if (r2 == null) {
            return;
        }
        if (this.getNeedAllFields()) {
            return;
        }
        if (r2.getNeedAllFields()) {
            this.mNeedAllFields = true;
            return;
        }
        if (this.getNeedNoFields() && !r2.getNeedNoFields()) {
            this.mNeedNoFields = false;
        }
        if (r2.getFields() == null) {
            return;
        }
        for (int i = 0; i < r2.size(); ++i) {
            Pair<Integer, Integer> f = r2.getField(i);
            MapKeysInfo m = r2.getMapKeysInfo(i);
            if (this.mFields == null) {
                this.mFields = new ArrayList<Pair<Integer, Integer>>();
                this.mMapKeysInfoList = new ArrayList<MapKeysInfo>();
            }
            if (!this.mFields.contains(f)) {
                this.mFields.add(f);
                this.mMapKeysInfoList.add(m);
                this.mNeedNoFields = false;
                continue;
            }
            if (m == null) continue;
            int index = this.mFields.indexOf(new Pair(f.first, f.second));
            MapKeysInfo mapKeys = this.mMapKeysInfoList.get(index);
            if (mapKeys == null) {
                mapKeys = new MapKeysInfo();
            }
            if (m.needAllKeys) {
                mapKeys.needAllKeys = true;
                mapKeys.keys = null;
            } else if (mapKeys.keys != null) {
                if (m.keys != null) {
                    mapKeys.keys.addAll(m.keys);
                }
            } else {
                mapKeys.keys = m.keys;
            }
            this.mMapKeysInfoList.set(index, mapKeys);
        }
    }

    public void reIndex(int i) {
        if (this.mFields != null) {
            for (Pair<Integer, Integer> p : this.mFields) {
                p.first = i;
            }
        }
    }

    public void mergeMapKey(int input, int column, String key) {
        int index = this.mFields.indexOf(new Pair<Integer, Integer>(input, column));
        if (index == -1) {
            return;
        }
        if (this.mMapKeysInfoList.get(index) == null) {
            this.mMapKeysInfoList.set(index, new MapKeysInfo());
        }
        MapKeysInfo keysInfo = this.mMapKeysInfoList.get(index);
        if (keysInfo.needAllKeys) {
            return;
        }
        if (!keysInfo.keys.contains(key)) {
            keysInfo.keys.add(key);
        }
    }

    public void mergeMapKeysInfo(int input, int column, MapKeysInfo mapKeysInfo) {
        if (mapKeysInfo == null) {
            return;
        }
        int index = this.mFields.indexOf(new Pair<Integer, Integer>(input, column));
        if (index == -1) {
            return;
        }
        if (this.mMapKeysInfoList.get(index) == null) {
            this.mMapKeysInfoList.set(index, mapKeysInfo);
            return;
        }
        if (mapKeysInfo.needAllKeys) {
            this.mMapKeysInfoList.get((int)index).needAllKeys = true;
            this.mMapKeysInfoList.get((int)index).keys = null;
        }
        if (mapKeysInfo.keys != null) {
            for (String key : mapKeysInfo.keys) {
                this.mergeMapKey(input, column, key);
            }
        }
    }

    public void setMapKeysInfo(int input, int column, MapKeysInfo mapKeysInfo) {
        int index = this.mFields.indexOf(new Pair<Integer, Integer>(input, column));
        if (index == -1) {
            return;
        }
        this.mMapKeysInfoList.set(index, mapKeysInfo);
    }

    public MapKeysInfo getMapKeysInfo(int i) {
        return this.mMapKeysInfoList.get(i);
    }

    public void setMapKeysInfo(int i, MapKeysInfo mapKeysInfo) {
        this.mMapKeysInfoList.set(i, mapKeysInfo);
    }
}

