/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.accumulo.core.client.impl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.rpc.SaslDigestCallbackHandler;
import org.apache.accumulo.server.rpc.UGIAssumingProcessor;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServerDigestCallbackHandler
extends SaslDigestCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(SaslServerDigestCallbackHandler.class);
    private static final String NAME = SaslServerDigestCallbackHandler.class.getSimpleName();
    private AuthenticationTokenSecretManager secretManager;

    public SaslServerDigestCallbackHandler(AuthenticationTokenSecretManager secretManager) {
        this.secretManager = secretManager;
    }

    private AuthenticationTokenIdentifier getIdentifier(String id, AuthenticationTokenSecretManager secretManager) throws SecretManager.InvalidToken {
        byte[] tokenId = this.decodeIdentifier(id);
        AuthenticationTokenIdentifier tokenIdentifier = secretManager.createIdentifier();
        try {
            tokenIdentifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        }
        catch (IOException e) {
            throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause((Throwable)e);
        }
        return tokenIdentifier;
    }

    public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
        NameCallback nc = null;
        PasswordCallback pc = null;
        AuthorizeCallback ac = null;
        for (Callback callback : callbacks) {
            if (callback instanceof AuthorizeCallback) {
                ac = (AuthorizeCallback)callback;
                continue;
            }
            if (callback instanceof NameCallback) {
                nc = (NameCallback)callback;
                continue;
            }
            if (callback instanceof PasswordCallback) {
                pc = (PasswordCallback)callback;
                continue;
            }
            if (callback instanceof RealmCallback) continue;
            throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
        }
        if (pc != null) {
            AuthenticationTokenIdentifier tokenIdentifier = this.getIdentifier(nc.getDefaultName(), this.secretManager);
            char[] password = this.getPassword(this.secretManager, (TokenIdentifier)tokenIdentifier);
            UserGroupInformation user = null;
            user = tokenIdentifier.getUser();
            UGIAssumingProcessor.getRpcPrincipalThreadLocal().set(user.getUserName());
            log.trace("SASL server DIGEST-MD5 callback: setting password for client: {}", (Object)tokenIdentifier.getUser());
            pc.setPassword(password);
        }
        if (ac != null) {
            String authzid;
            String authid = ac.getAuthenticationID();
            if (authid.equals(authzid = ac.getAuthorizationID())) {
                ac.setAuthorized(true);
            } else {
                ac.setAuthorized(false);
            }
            if (ac.isAuthorized()) {
                String username = this.getIdentifier(authzid, this.secretManager).getUser().getUserName();
                log.trace("SASL server DIGEST-MD5 callback: setting canonicalized client ID: {}", (Object)username);
                ac.setAuthorizedID(authzid);
            }
        }
    }

    public String toString() {
        return NAME;
    }
}

