/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.fetch;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.datastorage.DataStorageException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCross;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODemux;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PONative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POOptimizedForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartialAgg;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartitionRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPreCombinerLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.SampleLoader;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Utils;

public class FetchOptimizer {
    private static final Log LOG = LogFactory.getLog(FetchOptimizer.class);

    public static boolean isFetchEnabled(PigContext pc) {
        return "true".equalsIgnoreCase(pc.getProperties().getProperty("opt.fetch", "true"));
    }

    public static boolean isPlanFetchable(PigContext pc, PhysicalPlan pp) throws VisitorException {
        if (FetchOptimizer.isEligible(pc, pp)) {
            FetchablePlanVisitor fpv = new FetchablePlanVisitor(pc, pp);
            fpv.visit();
            if (!fpv.isPlanFetchable()) {
                return false;
            }
            for (POLoad load : PlanHelper.getPhysicalOperators(pp, POLoad.class)) {
                if (load.getLimit() != -1L) continue;
                return false;
            }
            pc.getProperties().setProperty("pig.job.converted.fetch", "true");
            FetchOptimizer.init(pp);
            return true;
        }
        return false;
    }

    private static void init(PhysicalPlan pp) throws VisitorException {
        LinkedList<POStream> posList = PlanHelper.getPhysicalOperators(pp, POStream.class);
        for (POStream pos : posList) {
            pos.setFetchable(true);
        }
    }

    private static boolean isEligible(PigContext pc, PhysicalPlan pp) {
        if (!FetchOptimizer.isFetchEnabled(pc)) {
            return false;
        }
        List roots = pp.getRoots();
        for (PhysicalOperator po : roots) {
            if (po instanceof POLoad) continue;
            String msg = "Expected physical operator at root is POLoad. Found : " + po.getClass().getCanonicalName() + ". Fetch optimizer will be disabled.";
            LOG.debug((Object)msg);
            return false;
        }
        int leafSize = pp.getLeaves().size();
        if (pp.getLeaves().size() != 1) {
            LOG.debug((Object)("Expected physical plan should have one leaf. Found " + leafSize));
            return false;
        }
        return true;
    }

    private static class FetchablePlanVisitor
    extends PhyPlanVisitor {
        private boolean planFetchable = true;
        private PigContext pc;

        public FetchablePlanVisitor(PigContext pc, PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.pc = pc;
        }

        @Override
        public void visit() throws VisitorException {
            super.visit();
        }

        @Override
        public void visitLoad(POLoad ld) throws VisitorException {
            if (ld.getLoadFunc() instanceof SampleLoader) {
                this.planFetchable = false;
            }
        }

        @Override
        public void visitStore(POStore st) throws VisitorException {
            String basePathName = st.getSFile().getFileName();
            if ("fakefile".equals(basePathName)) {
                return;
            }
            boolean hasTmpStorageClass = st.getStoreFunc().getClass().equals(Utils.getTmpFileStorageClass(this.pc.getProperties()));
            try {
                boolean hasTmpTargetPath = this.isTempPath(basePathName);
                if (!hasTmpStorageClass || !hasTmpTargetPath) {
                    this.planFetchable = false;
                }
            }
            catch (IOException e) {
                String msg = "Internal error. Could not retrieve temporary store location.";
                throw new VisitorException(msg, e);
            }
        }

        @Override
        public void visitNative(PONative nat) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitCollectedGroup(POCollectedGroup mg) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitLocalRearrange(POLocalRearrange lr) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitGlobalRearrange(POGlobalRearrange gr) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitPackage(POPackage pkg) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitSplit(POSplit spl) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitDemux(PODemux demux) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitCounter(POCounter poCounter) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitRank(PORank rank) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitDistinct(PODistinct distinct) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitSort(POSort sort) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitCross(POCross cross) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitFRJoin(POFRJoin join) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitMergeJoin(POMergeJoin join) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitMergeCoGroup(POMergeCogroup mergeCoGrp) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitSkewedJoin(POSkewedJoin sk) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitPartitionRearrange(POPartitionRearrange pr) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitPOOptimizedForEach(POOptimizedForEach optimizedForEach) throws VisitorException {
            this.planFetchable = false;
        }

        @Override
        public void visitPreCombinerLocalRearrange(POPreCombinerLocalRearrange preCombinerLocalRearrange) {
            this.planFetchable = false;
        }

        @Override
        public void visitPartialAgg(POPartialAgg poPartialAgg) {
            this.planFetchable = false;
        }

        private boolean isPlanFetchable() {
            return this.planFetchable;
        }

        private boolean isTempPath(String basePathName) throws DataStorageException {
            String tdir = this.pc.getProperties().getProperty("pig.temp.dir", "/tmp");
            String tempStore = this.pc.getDfs().asContainer(tdir + "/temp").toString();
            Matcher matcher = Pattern.compile(tempStore + "-?[0-9]+").matcher(basePathName);
            return matcher.lookingAt();
        }
    }
}

