/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.security.PrivilegedAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSourceImpl;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestMetricsUserAggregate {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsUserAggregate.class);
    private static MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private MetricsRegionServerWrapperStub wrapper;
    private MetricsRegionServer rsm;
    private MetricsUserAggregate userAgg;
    private TableName tableName = TableName.valueOf((String)"testUserAggregateMetrics");

    @BeforeClass
    public static void classSetUp() {
        HELPER.init();
    }

    @Before
    public void setUp() {
        this.wrapper = new MetricsRegionServerWrapperStub();
        Configuration conf = HBaseConfiguration.create();
        this.rsm = new MetricsRegionServer((MetricsRegionServerWrapper)this.wrapper, conf, null);
        this.userAgg = this.rsm.getMetricsUserAggregate();
    }

    private void doOperations() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.rsm.updateGet(this.tableName, 10L);
        }
        for (i = 0; i < 11; ++i) {
            this.rsm.updateScanTime(this.tableName, 11L);
        }
        for (i = 0; i < 12; ++i) {
            this.rsm.updatePut(this.tableName, 12L);
        }
        for (i = 0; i < 13; ++i) {
            this.rsm.updateDelete(this.tableName, 13L);
        }
        for (i = 0; i < 14; ++i) {
            this.rsm.updateIncrement(this.tableName, 14L);
        }
        for (i = 0; i < 15; ++i) {
            this.rsm.updateAppend(this.tableName, 15L);
        }
        for (i = 0; i < 16; ++i) {
            this.rsm.updateReplay(16L);
        }
    }

    @Test
    public void testPerUserOperations() {
        Configuration conf = HBaseConfiguration.create();
        if (!conf.getBoolean("hbase.regionserver.user.metrics.enabled", false)) {
            return;
        }
        User userFoo = User.createUserForTesting((Configuration)conf, (String)"FOO", (String[])new String[0]);
        User userBar = User.createUserForTesting((Configuration)conf, (String)"BAR", (String[])new String[0]);
        userFoo.getUGI().doAs((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                TestMetricsUserAggregate.this.doOperations();
                return null;
            }
        });
        userBar.getUGI().doAs((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                TestMetricsUserAggregate.this.doOperations();
                return null;
            }
        });
        HELPER.assertCounter("userfoometricgetnumops", 10L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userfoometricscantimenumops", 11L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userfoometricputnumops", 12L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userfoometricdeletenumops", 13L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userfoometricincrementnumops", 14L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userfoometricappendnumops", 15L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userfoometricreplaynumops", 16L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userbarmetricgetnumops", 10L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userbarmetricscantimenumops", 11L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userbarmetricputnumops", 12L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userbarmetricdeletenumops", 13L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userbarmetricincrementnumops", 14L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userbarmetricappendnumops", 15L, (BaseSource)this.userAgg.getSource());
        HELPER.assertCounter("userbarmetricreplaynumops", 16L, (BaseSource)this.userAgg.getSource());
    }

    @Test
    public void testLossyCountingOfUserMetrics() {
        int i;
        Configuration conf = HBaseConfiguration.create();
        if (!conf.getBoolean("hbase.regionserver.user.metrics.enabled", false)) {
            return;
        }
        int noOfUsers = 10000;
        for (i = 1; i <= noOfUsers; ++i) {
            User.createUserForTesting((Configuration)conf, (String)("FOO" + i), (String[])new String[0]).getUGI().doAs((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    TestMetricsUserAggregate.this.rsm.updateGet(TestMetricsUserAggregate.this.tableName, 10L);
                    return null;
                }
            });
        }
        Assert.assertTrue((((MetricsUserAggregateSourceImpl)this.userAgg.getSource()).getUserSources().size() <= noOfUsers / 10 ? 1 : 0) != 0);
        for (i = 1; i <= noOfUsers / 10; ++i) {
            Assert.assertFalse((boolean)HELPER.checkCounterExists("userfoo" + i + "metricgetnumops", (BaseSource)this.userAgg.getSource()));
        }
        HELPER.assertCounter("userfoo" + noOfUsers + "metricgetnumops", 1L, (BaseSource)this.userAgg.getSource());
    }
}

