/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestCompactor {
    public static HStoreFile createDummyStoreFile(long maxSequenceId) throws Exception {
        HStoreFile sf = (HStoreFile)Mockito.mock(HStoreFile.class);
        StoreFileReader r = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        Mockito.when((Object)r.length()).thenReturn((Object)1L);
        Mockito.when((Object)r.getBloomFilterType()).thenReturn((Object)BloomType.NONE);
        Mockito.when((Object)r.getHFileReader()).thenReturn(Mockito.mock(HFile.Reader.class));
        Mockito.when((Object)r.getStoreFileScanner(Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean())).thenReturn(Mockito.mock(StoreFileScanner.class));
        Mockito.when((Object)sf.getReader()).thenReturn((Object)r);
        Mockito.when((Object)sf.getMaxSequenceId()).thenReturn((Object)maxSequenceId);
        return sf;
    }

    public static CompactionRequestImpl createDummyRequest() throws Exception {
        return new CompactionRequestImpl(Arrays.asList(TestCompactor.createDummyStoreFile(1L)));
    }

    public static class Scanner
    implements InternalScanner {
        private final ArrayList<KeyValue> kvs;

        public Scanner(KeyValue ... kvs) {
            this.kvs = new ArrayList<KeyValue>(Arrays.asList(kvs));
        }

        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            if (this.kvs.isEmpty()) {
                return false;
            }
            result.add((Cell)this.kvs.remove(0));
            return !this.kvs.isEmpty();
        }

        public void close() throws IOException {
        }
    }

    public static class StoreFileWritersCapture
    implements Answer<StoreFileWriter>,
    AbstractMultiFileWriter.WriterFactory {
        private List<Writer> writers = new ArrayList<Writer>();

        public StoreFileWriter createWriter() throws IOException {
            final Writer realWriter = new Writer();
            this.writers.add(realWriter);
            StoreFileWriter writer = (StoreFileWriter)Mockito.mock(StoreFileWriter.class);
            ((StoreFileWriter)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    return realWriter.kvs.add((KeyValue)invocation.getArgument(0));
                }
            }).when((Object)writer)).append((Cell)Matchers.any());
            ((StoreFileWriter)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    Object[] args = invocation.getArguments();
                    return realWriter.data.put((byte[])args[0], (byte[])args[1]);
                }
            }).when((Object)writer)).appendFileInfo((byte[])Matchers.any(), (byte[])Matchers.any());
            ((StoreFileWriter)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    realWriter.hasMetadata = true;
                    return null;
                }
            }).when((Object)writer)).appendMetadata(Matchers.anyLong(), Matchers.anyBoolean());
            ((StoreFileWriter)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    realWriter.hasMetadata = true;
                    return null;
                }
            }).when((Object)writer)).appendMetadata(Matchers.anyLong(), Matchers.anyBoolean(), ArgumentMatchers.anyCollection());
            ((StoreFileWriter)Mockito.doAnswer((Answer)new Answer<Path>(){

                public Path answer(InvocationOnMock invocation) throws Throwable {
                    return new Path("foo");
                }
            }).when((Object)writer)).getPath();
            return writer;
        }

        public StoreFileWriter answer(InvocationOnMock invocation) throws Throwable {
            return this.createWriter();
        }

        public void verifyKvs(KeyValue[][] kvss, boolean allFiles, boolean requireMetadata) {
            if (allFiles) {
                Assert.assertEquals((long)kvss.length, (long)this.writers.size());
            }
            int skippedWriters = 0;
            for (int i = 0; i < kvss.length; ++i) {
                KeyValue[] kvs = kvss[i];
                if (kvs != null) {
                    Writer w = this.writers.get(i - skippedWriters);
                    if (requireMetadata) {
                        Assert.assertNotNull((Object)w.data.get(StripeStoreFileManager.STRIPE_START_KEY));
                        Assert.assertNotNull((Object)w.data.get(StripeStoreFileManager.STRIPE_END_KEY));
                    } else {
                        Assert.assertNull((Object)w.data.get(StripeStoreFileManager.STRIPE_START_KEY));
                        Assert.assertNull((Object)w.data.get(StripeStoreFileManager.STRIPE_END_KEY));
                    }
                    Assert.assertEquals((long)kvs.length, (long)w.kvs.size());
                    for (int j = 0; j < kvs.length; ++j) {
                        Assert.assertEquals((Object)kvs[j], (Object)w.kvs.get(j));
                    }
                    continue;
                }
                Assert.assertFalse((boolean)allFiles);
                ++skippedWriters;
            }
        }

        public void verifyBoundaries(byte[][] boundaries) {
            Assert.assertEquals((long)(boundaries.length - 1), (long)this.writers.size());
            for (int i = 0; i < this.writers.size(); ++i) {
                Assert.assertArrayEquals((String)("i = " + i), (byte[])boundaries[i], (byte[])this.writers.get((int)i).data.get(StripeStoreFileManager.STRIPE_START_KEY));
                Assert.assertArrayEquals((String)("i = " + i), (byte[])boundaries[i + 1], (byte[])this.writers.get((int)i).data.get(StripeStoreFileManager.STRIPE_END_KEY));
            }
        }

        public void verifyKvs(KeyValue[][] kvss, boolean allFiles, List<Long> boundaries) {
            if (allFiles) {
                Assert.assertEquals((long)kvss.length, (long)this.writers.size());
            }
            int skippedWriters = 0;
            for (int i = 0; i < kvss.length; ++i) {
                KeyValue[] kvs = kvss[i];
                if (kvs != null) {
                    Writer w = this.writers.get(i - skippedWriters);
                    Assert.assertEquals((long)kvs.length, (long)w.kvs.size());
                    for (int j = 0; j < kvs.length; ++j) {
                        Assert.assertTrue((kvs[j].getTimestamp() >= boundaries.get(i) ? 1 : 0) != 0);
                        Assert.assertTrue((kvs[j].getTimestamp() < boundaries.get(i + 1) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)kvs[j], (Object)w.kvs.get(j));
                    }
                    continue;
                }
                Assert.assertFalse((boolean)allFiles);
                ++skippedWriters;
            }
        }

        public List<Writer> getWriters() {
            return this.writers;
        }

        public static class Writer {
            public ArrayList<KeyValue> kvs = new ArrayList();
            public TreeMap<byte[], byte[]> data = new TreeMap(Bytes.BYTES_COMPARATOR);
            public boolean hasMetadata;
        }
    }
}

