/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.codahale.metrics.Counter;
import com.codahale.metrics.RatioGauge;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MetricsTests.class, SmallTests.class})
public class TestMetricsConnection {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsConnection.class);
    private static MetricsConnection METRICS;
    private static final ThreadPoolExecutor BATCH_POOL;

    @BeforeClass
    public static void beforeClass() {
        METRICS = new MetricsConnection("mocked-connection", () -> BATCH_POOL, () -> null);
    }

    @AfterClass
    public static void afterClass() {
        METRICS.shutdown();
    }

    @Test
    public void testStaticMetrics() throws IOException {
        byte[] foo = Bytes.toBytes((String)"foo");
        HBaseProtos.RegionSpecifier region = HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.EMPTY).setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).build();
        int loop = 5;
        for (int i = 0; i < 5; ++i) {
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Get"), (Message)ClientProtos.GetRequest.getDefaultInstance(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Scan"), (Message)ClientProtos.ScanRequest.getDefaultInstance(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Multi"), (Message)ClientProtos.MultiRequest.getDefaultInstance(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.APPEND, (Mutation)new Append(foo))).setRegion(region).build(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)new Delete(foo))).setRegion(region).build(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.INCREMENT, (Mutation)new Increment(foo))).setRegion(region).build(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)new Put(foo))).setRegion(region).build(), MetricsConnection.newCallStats());
        }
        for (String string : new String[]{"Get", "Scan", "Mutate"}) {
            String metricKey = "rpcCount_" + ClientProtos.ClientService.getDescriptor().getName() + "_" + string;
            long metricVal = ((Counter)TestMetricsConnection.METRICS.rpcCounters.get(metricKey)).getCount();
            Assert.assertTrue((String)("metric: " + metricKey + " val: " + metricVal), (metricVal >= 5L ? 1 : 0) != 0);
        }
        for (String string : new MetricsConnection.CallTracker[]{TestMetricsConnection.METRICS.getTracker, TestMetricsConnection.METRICS.scanTracker, TestMetricsConnection.METRICS.multiTracker, TestMetricsConnection.METRICS.appendTracker, TestMetricsConnection.METRICS.deleteTracker, TestMetricsConnection.METRICS.incrementTracker, TestMetricsConnection.METRICS.putTracker}) {
            Assert.assertEquals((String)("Failed to invoke callTimer on " + string), (long)5L, (long)((MetricsConnection.CallTracker)string).callTimer.getCount());
            Assert.assertEquals((String)("Failed to invoke reqHist on " + string), (long)5L, (long)((MetricsConnection.CallTracker)string).reqHist.getCount());
            Assert.assertEquals((String)("Failed to invoke respHist on " + string), (long)5L, (long)((MetricsConnection.CallTracker)string).respHist.getCount());
        }
        RatioGauge executorMetrics = (RatioGauge)METRICS.getMetricRegistry().getMetrics().get(METRICS.getExecutorPoolName());
        RatioGauge metaMetrics = (RatioGauge)METRICS.getMetricRegistry().getMetrics().get(METRICS.getMetaPoolName());
        Assert.assertEquals((double)RatioGauge.Ratio.of((double)0.0, (double)3.0).getValue(), (double)executorMetrics.getValue(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)metaMetrics.getValue(), (double)0.0);
    }

    static {
        BATCH_POOL = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
    }
}

