/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.FailedRemoteDispatchException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ServerRemoteProcedure
extends Procedure<MasterProcedureEnv>
implements RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    protected static final Logger LOG = LoggerFactory.getLogger(ServerRemoteProcedure.class);
    protected ProcedureEvent<?> event;
    protected ServerName targetServer;
    protected boolean dispatched;
    protected boolean succ;

    protected abstract void complete(MasterProcedureEnv var1, Throwable var2);

    protected synchronized Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        if (this.dispatched) {
            if (this.succ) {
                return null;
            }
            this.dispatched = false;
        }
        try {
            env.getRemoteDispatcher().addOperationToNode((Comparable)this.targetServer, this);
        }
        catch (FailedRemoteDispatchException frde) {
            LOG.warn("Can not send remote operation {} to {}, this operation will be retried to send to another server", (Object)this.getProcId(), (Object)this.targetServer);
            return null;
        }
        this.dispatched = true;
        this.event = new ProcedureEvent((Object)this);
        this.event.suspendIfNotReady((Procedure)this);
        throw new ProcedureSuspendedException();
    }

    protected synchronized void completionCleanup(MasterProcedureEnv env) {
        env.getRemoteDispatcher().removeCompletedOperation((Comparable)this.targetServer, this);
    }

    public synchronized void remoteCallFailed(MasterProcedureEnv env, ServerName serverName, IOException exception) {
        this.remoteOperationDone(env, exception);
    }

    public synchronized void remoteOperationCompleted(MasterProcedureEnv env) {
        this.remoteOperationDone(env, null);
    }

    public synchronized void remoteOperationFailed(MasterProcedureEnv env, RemoteProcedureException error) {
        this.remoteOperationDone(env, (Throwable)error);
    }

    synchronized void remoteOperationDone(MasterProcedureEnv env, Throwable error) {
        if (this.isFinished()) {
            LOG.info("This procedure {} is already finished, skip the rest processes", (Object)this.getProcId());
            return;
        }
        if (this.event == null) {
            LOG.warn("procedure event for {} is null, maybe the procedure is created when recovery", (Object)this.getProcId());
            return;
        }
        this.complete(env, error);
        this.event.wake((AbstractProcedureScheduler)env.getProcedureScheduler());
        this.event = null;
    }
}

