/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.control;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.BytecodeVisitor;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.control.FlowControl;
import io.airlift.bytecode.instruction.LabelNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class ForLoop
implements FlowControl {
    private final String comment;
    private final BytecodeBlock initialize = new BytecodeBlock();
    private final BytecodeBlock condition = new BytecodeBlock();
    private final BytecodeBlock update = new BytecodeBlock();
    private final BytecodeBlock body = new BytecodeBlock();
    private final LabelNode beginLabel = new LabelNode("beginLabel");
    private final LabelNode continueLabel = new LabelNode("continue");
    private final LabelNode endLabel = new LabelNode("end");

    public ForLoop() {
        this.comment = null;
    }

    public ForLoop(String format, Object ... args) {
        this.comment = String.format(format, args);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public LabelNode getContinueLabel() {
        return this.continueLabel;
    }

    public LabelNode getEndLabel() {
        return this.endLabel;
    }

    public BytecodeBlock initialize() {
        return this.initialize;
    }

    public ForLoop initialize(BytecodeNode node) {
        Preconditions.checkState((boolean)this.initialize.isEmpty(), (Object)"initialize already set");
        this.initialize.append(node);
        return this;
    }

    public BytecodeBlock condition() {
        return this.condition;
    }

    public ForLoop condition(BytecodeNode node) {
        Preconditions.checkState((boolean)this.condition.isEmpty(), (Object)"condition already set");
        this.condition.append(node);
        return this;
    }

    public BytecodeBlock update() {
        return this.update;
    }

    public ForLoop update(BytecodeNode node) {
        Preconditions.checkState((boolean)this.update.isEmpty(), (Object)"update already set");
        this.update.append(node);
        return this;
    }

    public BytecodeBlock body() {
        return this.body;
    }

    public ForLoop body(BytecodeNode node) {
        Preconditions.checkState((boolean)this.body.isEmpty(), (Object)"body already set");
        this.body.append(node);
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        Preconditions.checkState((!this.condition.isEmpty() ? 1 : 0) != 0, (Object)"ForLoop does not have a condition set");
        BytecodeBlock block = new BytecodeBlock();
        block.append(new BytecodeBlock().setDescription("initialize").append(this.initialize));
        block.visitLabel(this.beginLabel).append(new BytecodeBlock().setDescription("condition").append(this.condition)).ifFalseGoto(this.endLabel);
        block.append(new BytecodeBlock().setDescription("body").append(this.body));
        block.visitLabel(this.continueLabel).append(new BytecodeBlock().setDescription("update").append(this.update)).gotoLabel(this.beginLabel).visitLabel(this.endLabel);
        block.accept(visitor, generationContext);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.initialize, (Object)this.condition, (Object)this.update, (Object)this.body);
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitFor(parent, this);
    }
}

