/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.commons.collections4.MapUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTracker;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTrackerFactory;
import org.apache.pulsar.broker.delayed.bucket.BookkeeperBucketSnapshotStorage;
import org.apache.pulsar.broker.delayed.bucket.BucketDelayedDeliveryTracker;
import org.apache.pulsar.broker.delayed.bucket.BucketSnapshotStorage;
import org.apache.pulsar.broker.delayed.bucket.RecoverDelayedDeliveryTrackerException;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketDelayedDeliveryTrackerFactory
implements DelayedDeliveryTrackerFactory {
    private static final Logger log = LoggerFactory.getLogger(BucketDelayedDeliveryTrackerFactory.class);
    BucketSnapshotStorage bucketSnapshotStorage;
    private Timer timer;
    private long tickTimeMillis;
    private boolean isDelayedDeliveryDeliverAtTimeStrict;
    private int delayedDeliveryMaxNumBuckets;
    private long delayedDeliveryMinIndexCountPerBucket;
    private int delayedDeliveryMaxTimeStepPerBucketSnapshotSegmentSeconds;
    private int delayedDeliveryMaxIndexesPerBucketSnapshotSegment;

    @Override
    public void initialize(PulsarService pulsarService) throws Exception {
        ServiceConfiguration config = pulsarService.getConfig();
        this.bucketSnapshotStorage = new BookkeeperBucketSnapshotStorage(pulsarService);
        this.bucketSnapshotStorage.start();
        this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("pulsar-delayed-delivery"), config.getDelayedDeliveryTickTimeMillis(), TimeUnit.MILLISECONDS);
        this.tickTimeMillis = config.getDelayedDeliveryTickTimeMillis();
        this.isDelayedDeliveryDeliverAtTimeStrict = config.isDelayedDeliveryDeliverAtTimeStrict();
        this.delayedDeliveryMinIndexCountPerBucket = config.getDelayedDeliveryMinIndexCountPerBucket();
        this.delayedDeliveryMaxNumBuckets = config.getDelayedDeliveryMaxNumBuckets();
        this.delayedDeliveryMaxTimeStepPerBucketSnapshotSegmentSeconds = config.getDelayedDeliveryMaxTimeStepPerBucketSnapshotSegmentSeconds();
        this.delayedDeliveryMaxIndexesPerBucketSnapshotSegment = config.getDelayedDeliveryMaxIndexesPerBucketSnapshotSegment();
    }

    @Override
    public DelayedDeliveryTracker newTracker(PersistentDispatcherMultipleConsumers dispatcher) {
        DelayedDeliveryTracker tracker;
        String topicName = dispatcher.getTopic().getName();
        String subscriptionName = dispatcher.getSubscription().getName();
        BrokerService brokerService = dispatcher.getTopic().getBrokerService();
        try {
            tracker = this.newTracker0(dispatcher);
        }
        catch (RecoverDelayedDeliveryTrackerException ex) {
            log.warn("Failed to recover BucketDelayedDeliveryTracker, fallback to InMemoryDelayedDeliveryTracker. topic {}, subscription {}", new Object[]{topicName, subscriptionName, ex});
            brokerService.initializeFallbackDelayedDeliveryTrackerFactory();
            tracker = brokerService.getFallbackDelayedDeliveryTrackerFactory().newTracker(dispatcher);
        }
        return tracker;
    }

    @VisibleForTesting
    BucketDelayedDeliveryTracker newTracker0(PersistentDispatcherMultipleConsumers dispatcher) throws RecoverDelayedDeliveryTrackerException {
        return new BucketDelayedDeliveryTracker(dispatcher, this.timer, this.tickTimeMillis, this.isDelayedDeliveryDeliverAtTimeStrict, this.bucketSnapshotStorage, this.delayedDeliveryMinIndexCountPerBucket, TimeUnit.SECONDS.toMillis(this.delayedDeliveryMaxTimeStepPerBucketSnapshotSegmentSeconds), this.delayedDeliveryMaxIndexesPerBucketSnapshotSegment, this.delayedDeliveryMaxNumBuckets);
    }

    public CompletableFuture<Void> cleanResidualSnapshots(ManagedCursor cursor) {
        Map cursorProperties = cursor.getCursorProperties();
        if (MapUtils.isEmpty((Map)cursorProperties)) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList futures = new ArrayList();
        FutureUtil.Sequencer sequencer = FutureUtil.Sequencer.create();
        cursorProperties.forEach((k, v) -> {
            if (k != null && v != null && k.startsWith("#pulsar.internal.delayed.bucket")) {
                CompletableFuture future = sequencer.sequential(() -> this.bucketSnapshotStorage.deleteBucketSnapshot(Long.parseLong(v)).thenCompose(__ -> cursor.removeCursorProperty(k)));
                futures.add(future);
            }
        });
        return FutureUtil.waitForAll(futures);
    }

    @Override
    public void close() throws Exception {
        if (this.bucketSnapshotStorage != null) {
            this.bucketSnapshotStorage.close();
        }
    }
}

