/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.ToLongFunction;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Subscription;

public abstract class AbstractSubscription
implements Subscription {
    protected final LongAdder bytesOutFromRemovedConsumers = new LongAdder();
    protected final LongAdder msgOutFromRemovedConsumer = new LongAdder();

    public long getMsgOutCounter() {
        return this.msgOutFromRemovedConsumer.longValue() + this.sumConsumers(Consumer::getMsgOutCounter);
    }

    public long getBytesOutCounter() {
        return this.bytesOutFromRemovedConsumers.longValue() + this.sumConsumers(Consumer::getBytesOutCounter);
    }

    private long sumConsumers(ToLongFunction<Consumer> toCounter) {
        return Optional.ofNullable(this.getDispatcher()).map(dispatcher -> dispatcher.getConsumers().stream().mapToLong(toCounter).sum()).orElse(0L);
    }
}

