/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.operator.BlockedReason;
import io.trino.operator.DriverStats;
import io.trino.operator.OperatorStats;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class PipelineStats {
    private final int pipelineId;
    private final DateTime firstStartTime;
    private final DateTime lastStartTime;
    private final DateTime lastEndTime;
    private final boolean inputPipeline;
    private final boolean outputPipeline;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int queuedPartitionedDrivers;
    private final long queuedPartitionedSplitsWeight;
    private final int runningDrivers;
    private final int runningPartitionedDrivers;
    private final long runningPartitionedSplitsWeight;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final DataSize userMemoryReservation;
    private final DataSize revocableMemoryReservation;
    private final DataSize systemMemoryReservation;
    private final Distribution.DistributionSnapshot queuedTime;
    private final Distribution.DistributionSnapshot elapsedTime;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize physicalInputDataSize;
    private final long physicalInputPositions;
    private final Duration physicalInputReadTime;
    private final DataSize internalNetworkInputDataSize;
    private final long internalNetworkInputPositions;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final DataSize physicalWrittenDataSize;
    private final List<OperatorStats> operatorSummaries;
    private final List<DriverStats> drivers;

    @JsonCreator
    public PipelineStats(@JsonProperty(value="pipelineId") int pipelineId, @JsonProperty(value="firstStartTime") DateTime firstStartTime, @JsonProperty(value="lastStartTime") DateTime lastStartTime, @JsonProperty(value="lastEndTime") DateTime lastEndTime, @JsonProperty(value="inputPipeline") boolean inputPipeline, @JsonProperty(value="outputPipeline") boolean outputPipeline, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="queuedPartitionedDrivers") int queuedPartitionedDrivers, @JsonProperty(value="queuedPartitionedSplitsWeight") long queuedPartitionedSplitsWeight, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="runningPartitionedDrivers") int runningPartitionedDrivers, @JsonProperty(value="runningPartitionedSplitsWeight") long runningPartitionedSplitsWeight, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="revocableMemoryReservation") DataSize revocableMemoryReservation, @JsonProperty(value="systemMemoryReservation") DataSize systemMemoryReservation, @JsonProperty(value="queuedTime") Distribution.DistributionSnapshot queuedTime, @JsonProperty(value="elapsedTime") Distribution.DistributionSnapshot elapsedTime, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="physicalInputDataSize") DataSize physicalInputDataSize, @JsonProperty(value="physicalInputPositions") long physicalInputPositions, @JsonProperty(value="physicalInputReadTime") Duration physicalInputReadTime, @JsonProperty(value="internalNetworkInputDataSize") DataSize internalNetworkInputDataSize, @JsonProperty(value="internalNetworkInputPositions") long internalNetworkInputPositions, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="operatorSummaries") List<OperatorStats> operatorSummaries, @JsonProperty(value="drivers") List<DriverStats> drivers) {
        this.pipelineId = pipelineId;
        this.firstStartTime = firstStartTime;
        this.lastStartTime = lastStartTime;
        this.lastEndTime = lastEndTime;
        this.inputPipeline = inputPipeline;
        this.outputPipeline = outputPipeline;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((queuedPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedPartitionedDrivers is negative");
        this.queuedPartitionedDrivers = queuedPartitionedDrivers;
        Preconditions.checkArgument((queuedPartitionedSplitsWeight >= 0L ? 1 : 0) != 0, (Object)"queuedPartitionedSplitsWeight must be positive");
        this.queuedPartitionedSplitsWeight = queuedPartitionedSplitsWeight;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((runningPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"runningPartitionedDrivers is negative");
        this.runningPartitionedDrivers = runningPartitionedDrivers;
        Preconditions.checkArgument((runningPartitionedSplitsWeight >= 0L ? 1 : 0) != 0, (Object)"runningPartitionedSplitsWeight must be positive");
        this.runningPartitionedSplitsWeight = runningPartitionedSplitsWeight;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.revocableMemoryReservation = Objects.requireNonNull(revocableMemoryReservation, "revocableMemoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.physicalInputDataSize = Objects.requireNonNull(physicalInputDataSize, "physicalInputDataSize is null");
        Preconditions.checkArgument((physicalInputPositions >= 0L ? 1 : 0) != 0, (Object)"physicalInputPositions is negative");
        this.physicalInputPositions = physicalInputPositions;
        this.physicalInputReadTime = Objects.requireNonNull(physicalInputReadTime, "physicalInputReadTime is null");
        this.internalNetworkInputDataSize = Objects.requireNonNull(internalNetworkInputDataSize, "internalNetworkInputDataSize is null");
        Preconditions.checkArgument((internalNetworkInputPositions >= 0L ? 1 : 0) != 0, (Object)"internalNetworkInputPositions is negative");
        this.internalNetworkInputPositions = internalNetworkInputPositions;
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "physicalWrittenDataSize is null");
        this.operatorSummaries = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorSummaries, "operatorSummaries is null"));
        this.drivers = ImmutableList.copyOf((Collection)Objects.requireNonNull(drivers, "drivers is null"));
    }

    @JsonProperty
    public int getPipelineId() {
        return this.pipelineId;
    }

    @Nullable
    @JsonProperty
    public DateTime getFirstStartTime() {
        return this.firstStartTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getLastStartTime() {
        return this.lastStartTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getLastEndTime() {
        return this.lastEndTime;
    }

    @JsonProperty
    public boolean isInputPipeline() {
        return this.inputPipeline;
    }

    @JsonProperty
    public boolean isOutputPipeline() {
        return this.outputPipeline;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getQueuedPartitionedDrivers() {
        return this.queuedPartitionedDrivers;
    }

    @JsonProperty
    public long getQueuedPartitionedSplitsWeight() {
        return this.queuedPartitionedSplitsWeight;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getRunningPartitionedDrivers() {
        return this.runningPartitionedDrivers;
    }

    @JsonProperty
    public long getRunningPartitionedSplitsWeight() {
        return this.runningPartitionedSplitsWeight;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getRevocableMemoryReservation() {
        return this.revocableMemoryReservation;
    }

    @JsonProperty
    public DataSize getSystemMemoryReservation() {
        return this.systemMemoryReservation;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public DataSize getPhysicalInputDataSize() {
        return this.physicalInputDataSize;
    }

    @JsonProperty
    public long getPhysicalInputPositions() {
        return this.physicalInputPositions;
    }

    @JsonProperty
    public DataSize getInternalNetworkInputDataSize() {
        return this.internalNetworkInputDataSize;
    }

    @JsonProperty
    public long getInternalNetworkInputPositions() {
        return this.internalNetworkInputPositions;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public Duration getPhysicalInputReadTime() {
        return this.physicalInputReadTime;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    @JsonProperty
    public List<DriverStats> getDrivers() {
        return this.drivers;
    }

    public PipelineStats summarize() {
        return new PipelineStats(this.pipelineId, this.firstStartTime, this.lastStartTime, this.lastEndTime, this.inputPipeline, this.outputPipeline, this.totalDrivers, this.queuedDrivers, this.queuedPartitionedDrivers, this.queuedPartitionedSplitsWeight, this.runningDrivers, this.runningPartitionedDrivers, this.runningPartitionedSplitsWeight, this.blockedDrivers, this.completedDrivers, this.userMemoryReservation, this.revocableMemoryReservation, this.systemMemoryReservation, this.queuedTime, this.elapsedTime, this.totalScheduledTime, this.totalCpuTime, this.totalBlockedTime, this.fullyBlocked, this.blockedReasons, this.physicalInputDataSize, this.physicalInputPositions, this.physicalInputReadTime, this.internalNetworkInputDataSize, this.internalNetworkInputPositions, this.rawInputDataSize, this.rawInputPositions, this.processedInputDataSize, this.processedInputPositions, this.outputDataSize, this.outputPositions, this.physicalWrittenDataSize, PipelineStats.summarizeOperatorStats(this.operatorSummaries), (List<DriverStats>)ImmutableList.of());
    }

    private static List<OperatorStats> summarizeOperatorStats(List<OperatorStats> operatorSummaries) {
        ImmutableList.Builder results = ImmutableList.builderWithExpectedSize((int)operatorSummaries.size());
        for (OperatorStats operatorStats : operatorSummaries) {
            results.add((Object)operatorStats.summarize());
        }
        return results.build();
    }
}

