/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;

public class NullableLongStateSerializer
implements AccumulatorStateSerializer<NullableLongState> {
    public Type getSerializedType() {
        return BigintType.BIGINT;
    }

    public void serialize(NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BigintType.BIGINT.writeLong(out, state.getValue());
        }
    }

    public void deserialize(Block block, int index, NullableLongState state) {
        if (block.isNull(index)) {
            state.setNull(true);
        } else {
            state.setNull(false);
            state.setValue(BigintType.BIGINT.getLong(block, index));
        }
    }
}

