/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;

public class AssignUniqueId
extends PlanNode {
    private final PlanNode source;
    private final Symbol idColumn;

    @JsonCreator
    public AssignUniqueId(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="idColumn") Symbol idColumn) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.idColumn = Objects.requireNonNull(idColumn, "idColumn is null");
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.source.getOutputSymbols()).add((Object)this.idColumn).build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public Symbol getIdColumn() {
        return this.idColumn;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAssignUniqueId(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 1 ? 1 : 0) != 0, (Object)"expected newChildren to contain 1 node");
        return new AssignUniqueId(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.idColumn);
    }
}

