/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.base.Preconditions;
import io.trino.cost.PlanCostEstimate;
import io.trino.cost.PlanNodeStatsAndCostSummary;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.planprinter.PlanNodeStats;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NodeRepresentation {
    private final PlanNodeId id;
    private final String name;
    private final String type;
    private final String identifier;
    private final List<TypedSymbol> outputs;
    private final List<PlanNodeId> children;
    private final List<PlanFragmentId> remoteSources;
    private final Optional<PlanNodeStats> stats;
    private final List<PlanNodeStatsEstimate> estimatedStats;
    private final List<PlanCostEstimate> estimatedCost;
    private final Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost;
    private final StringBuilder details = new StringBuilder();

    public NodeRepresentation(PlanNodeId id, String name, String type, String identifier, List<TypedSymbol> outputs, Optional<PlanNodeStats> stats, List<PlanNodeStatsEstimate> estimatedStats, List<PlanCostEstimate> estimatedCost, Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost, List<PlanNodeId> children, List<PlanFragmentId> remoteSources) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.identifier = Objects.requireNonNull(identifier, "identifier is null");
        this.outputs = Objects.requireNonNull(outputs, "outputs is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.estimatedStats = Objects.requireNonNull(estimatedStats, "estimatedStats is null");
        this.estimatedCost = Objects.requireNonNull(estimatedCost, "estimatedCost is null");
        this.reorderJoinStatsAndCost = Objects.requireNonNull(reorderJoinStatsAndCost, "reorderJoinStatsAndCost is null");
        this.children = Objects.requireNonNull(children, "children is null");
        this.remoteSources = Objects.requireNonNull(remoteSources, "remoteSources is null");
        Preconditions.checkArgument((estimatedCost.size() == estimatedStats.size() ? 1 : 0) != 0, (Object)"size of cost and stats list does not match");
    }

    public void appendDetails(String string, Object ... args) {
        if (args.length == 0) {
            this.details.append(string);
        } else {
            this.details.append(String.format(string, args));
        }
    }

    public void appendDetailsLine(String string, Object ... args) {
        this.appendDetails(string, args);
        this.details.append('\n');
    }

    public PlanNodeId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<TypedSymbol> getOutputs() {
        return this.outputs;
    }

    public List<PlanNodeId> getChildren() {
        return this.children;
    }

    public List<PlanFragmentId> getRemoteSources() {
        return this.remoteSources;
    }

    public String getDetails() {
        return this.details.toString();
    }

    public Optional<PlanNodeStats> getStats() {
        return this.stats;
    }

    public List<PlanNodeStatsEstimate> getEstimatedStats() {
        return this.estimatedStats;
    }

    public List<PlanCostEstimate> getEstimatedCost() {
        return this.estimatedCost;
    }

    public Optional<PlanNodeStatsAndCostSummary> getReorderJoinStatsAndCost() {
        return this.reorderJoinStatsAndCost;
    }

    public static class TypedSymbol {
        private final Symbol symbol;
        private final String type;

        public TypedSymbol(Symbol symbol, String type) {
            this.symbol = symbol;
            this.type = type;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public String getType() {
            return this.type;
        }
    }
}

