/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import java.util.Queue;
import org.apache.qpid.protonj2.engine.impl.ProtonSequentialTagGenerator;
import org.apache.qpid.protonj2.engine.util.RingQueue;
import org.apache.qpid.protonj2.types.DeliveryTag;

public class ProtonPooledTagGenerator
extends ProtonSequentialTagGenerator {
    public static final int DEFAULT_MAX_NUM_POOLED_TAGS = 512;
    private final int tagPoolSize;
    private final Queue<ProtonPooledDeliveryTag> tagPool;

    public ProtonPooledTagGenerator() {
        this(512);
    }

    public ProtonPooledTagGenerator(int poolSize) {
        if (poolSize == 0) {
            throw new IllegalArgumentException("Cannot create a tag pool with zero pool size");
        }
        if (poolSize < 0) {
            throw new IllegalArgumentException("Cannot create a tag pool with negative pool size");
        }
        this.tagPoolSize = poolSize;
        this.tagPool = new RingQueue<ProtonPooledDeliveryTag>(this.tagPoolSize);
    }

    @Override
    public DeliveryTag nextTag() {
        ProtonPooledDeliveryTag nextTag = this.tagPool.poll();
        if (nextTag != null) {
            return nextTag.checkOut();
        }
        return this.createTag();
    }

    private DeliveryTag createTag() {
        DeliveryTag nextTag = null;
        if (this.nextTagId >= 0L && this.nextTagId < (long)this.tagPoolSize) {
            nextTag = new ProtonPooledDeliveryTag((byte)this.nextTagId++).checkOut();
        } else {
            nextTag = super.nextTag();
            if (this.nextTagId == 0L) {
                this.nextTagId = this.tagPoolSize;
            }
        }
        return nextTag;
    }

    @Override
    void setNextTagId(long nextIdValue) {
        this.nextTagId = nextIdValue;
    }

    private class ProtonPooledDeliveryTag
    extends ProtonSequentialTagGenerator.ProtonNumericDeliveryTag {
        private boolean checkedOut;

        public ProtonPooledDeliveryTag(long tagValue) {
            super(tagValue);
        }

        public ProtonPooledDeliveryTag checkOut() {
            this.checkedOut = true;
            return this;
        }

        @Override
        public void release() {
            if (this.checkedOut) {
                ProtonPooledTagGenerator.this.tagPool.offer(this);
                this.checkedOut = false;
            }
        }
    }
}

