/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.header;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.action.Action;
import org.apache.rocketmq.common.action.RocketMQAction;
import org.apache.rocketmq.common.resource.ResourceType;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;

@RocketMQAction(value=355, resource=ResourceType.CLUSTER, action={Action.GET})
public class ExportRocksDBConfigToJsonRequestHeader
implements CommandCustomHeader {
    private static final String CONFIG_TYPE_SEPARATOR = ";";
    @CFNotNull
    private String configType;

    @Override
    public void checkFields() throws RemotingCommandException {
    }

    public List<ConfigType> fetchConfigType() {
        return ConfigType.fromString(this.configType);
    }

    public void updateConfigType(List<ConfigType> configType) {
        this.configType = ConfigType.toString(configType);
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public static enum ConfigType {
        TOPICS("topics"),
        SUBSCRIPTION_GROUPS("subscriptionGroups"),
        CONSUMER_OFFSETS("consumerOffsets");

        private final String typeName;

        private ConfigType(String typeName) {
            this.typeName = typeName;
        }

        public static ConfigType getConfigTypeByName(String typeName) {
            for (ConfigType configType : ConfigType.values()) {
                if (!configType.getTypeName().equalsIgnoreCase(typeName.trim())) continue;
                return configType;
            }
            throw new IllegalArgumentException("Unknown config type: " + typeName);
        }

        public static List<ConfigType> fromString(String ordinal) {
            String[] configTypeNames = StringUtils.split((String)ordinal, (String)ExportRocksDBConfigToJsonRequestHeader.CONFIG_TYPE_SEPARATOR);
            ArrayList<ConfigType> configTypes = new ArrayList<ConfigType>();
            for (String configTypeName : configTypeNames) {
                if (!StringUtils.isNotEmpty((CharSequence)configTypeName)) continue;
                configTypes.add(ConfigType.getConfigTypeByName(configTypeName));
            }
            return configTypes;
        }

        public static String toString(List<ConfigType> configTypes) {
            StringBuilder sb = new StringBuilder();
            for (ConfigType configType : configTypes) {
                sb.append(configType.getTypeName()).append(ExportRocksDBConfigToJsonRequestHeader.CONFIG_TYPE_SEPARATOR);
            }
            return sb.toString();
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

