/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.geom.Point2D;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterBandAccessors;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class GeometryFunctions {
    public static Geometry convexHull(GridCoverage2D raster) throws FactoryException, TransformException {
        int width = RasterAccessors.getWidth(raster);
        int height = RasterAccessors.getHeight(raster);
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), RasterAccessors.srid(raster));
        double upperLeftX = RasterAccessors.getUpperLeftX(raster);
        double upperLeftY = RasterAccessors.getUpperLeftY(raster);
        Coordinate coordOne = new Coordinate(upperLeftX, upperLeftY);
        Point2D point = RasterUtils.getWorldCornerCoordinates(raster, width + 1, 1);
        Coordinate coordTwo = new Coordinate(point.getX(), point.getY());
        point = RasterUtils.getWorldCornerCoordinates(raster, width + 1, height + 1);
        Coordinate coordThree = new Coordinate(point.getX(), point.getY());
        point = RasterUtils.getWorldCornerCoordinates(raster, 1, height + 1);
        Coordinate coordFour = new Coordinate(point.getX(), point.getY());
        return geometryFactory.createPolygon(new Coordinate[]{coordOne, coordTwo, coordThree, coordFour, coordOne});
    }

    public static Geometry minConvexHull(GridCoverage2D raster, Integer band) throws FactoryException, TransformException {
        boolean allBands;
        boolean bl = allBands = band == null;
        if (!allBands) {
            GeometryFunctions.ensureSafeBand(raster, band);
        }
        int width = RasterAccessors.getWidth(raster);
        int height = RasterAccessors.getHeight(raster);
        int srid = RasterAccessors.srid(raster);
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                GridCoordinates2D currGridCoordinate = new GridCoordinates2D(i, j);
                double[] bandPixelValues = raster.evaluate(currGridCoordinate, (double[])null);
                int start = band == null ? 1 : band;
                int end = band == null ? RasterAccessors.numBands(raster) : band;
                for (int currBand = start; currBand <= end; ++currBand) {
                    double currBandValue = bandPixelValues[currBand - 1];
                    Double bandNoDataValue = RasterBandAccessors.getBandNoDataValue(raster, currBand);
                    if (bandNoDataValue != null && currBandValue == bandNoDataValue) continue;
                    minX = Math.min(minX, i + 1);
                    maxX = Math.max(maxX, i + 1);
                    minY = Math.min(minY, j + 1);
                    maxY = Math.max(maxY, j + 1);
                }
            }
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        Point2D worldUpperLeft = RasterUtils.getWorldCornerCoordinates(raster, minX, minY);
        Point2D worldUpperRight = RasterUtils.getWorldCornerCoordinates(raster, maxX + 1, minY);
        Point2D worldLowerRight = RasterUtils.getWorldCornerCoordinates(raster, maxX + 1, maxY + 1);
        Point2D worldLowerLeft = RasterUtils.getWorldCornerCoordinates(raster, minX, maxY + 1);
        return geometryFactory.createPolygon(new Coordinate[]{GeometryFunctions.convertToCoordinate(worldUpperLeft), GeometryFunctions.convertToCoordinate(worldUpperRight), GeometryFunctions.convertToCoordinate(worldLowerRight), GeometryFunctions.convertToCoordinate(worldLowerLeft), GeometryFunctions.convertToCoordinate(worldUpperLeft)});
    }

    private static Coordinate convertToCoordinate(Point2D point) {
        double x = point.getX();
        double y = point.getY();
        if (Math.abs(x) == 0.0) {
            x = 0.0;
        }
        if (Math.abs(y) == 0.0) {
            y = 0.0;
        }
        return new Coordinate(x, y);
    }

    public static Geometry minConvexHull(GridCoverage2D raster) throws FactoryException, TransformException {
        return GeometryFunctions.minConvexHull(raster, null);
    }

    public static void ensureSafeBand(GridCoverage2D raster, int band) throws IllegalArgumentException {
        if (RasterAccessors.numBands(raster) < band) {
            throw new IllegalArgumentException(String.format("Provided band index %d does not lie in the raster", band));
        }
    }

    public static Geometry envelope(GridCoverage2D raster) throws FactoryException {
        ReferencedEnvelope envelope2D = raster.getEnvelope2D();
        Envelope envelope = new Envelope(envelope2D.getMinX(), envelope2D.getMaxX(), envelope2D.getMinY(), envelope2D.getMaxY());
        int srid = RasterAccessors.srid(raster);
        return new GeometryFactory(new PrecisionModel(), srid).toGeometry(envelope);
    }
}

