/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.DisposableHolder;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.policy.FaultInjectionPolicy;
import org.apache.servicecomb.governance.processor.injection.Fault;
import org.apache.servicecomb.governance.processor.injection.FaultInjectionUtil;
import org.apache.servicecomb.governance.properties.FaultInjectionProperties;

public class FaultInjectionHandler
extends AbstractGovernanceHandler<Fault, FaultInjectionPolicy> {
    private final FaultInjectionProperties faultInjectionProperties;

    public FaultInjectionHandler(FaultInjectionProperties faultInjectionProperties) {
        this.faultInjectionProperties = faultInjectionProperties;
    }

    @Override
    protected String createKey(GovernanceRequestExtractor requestExtractor, FaultInjectionPolicy policy) {
        return "servicecomb.faultInjection." + policy.getName();
    }

    @Override
    public FaultInjectionPolicy matchPolicy(GovernanceRequestExtractor requestExtractor) {
        return (FaultInjectionPolicy)this.matchersManager.match(requestExtractor, this.faultInjectionProperties.getParsedEntity());
    }

    @Override
    protected DisposableHolder<Fault> createProcessor(String key, GovernanceRequestExtractor requestExtractor, FaultInjectionPolicy policy) {
        return new DisposableHolder<Fault>(key, FaultInjectionUtil.getFault(key, policy));
    }
}

