/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.invocation;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.List;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.metrics.meter.SimpleTimer;
import org.apache.servicecomb.metrics.core.meter.invocation.AbstractInvocationMeter;

public class ConsumerInvocationMeter
extends AbstractInvocationMeter {
    private final SimpleTimer clientFiltersRequestTimer = this.createStageTimer("client_filters_request");
    private final SimpleTimer consumerSendRequestTimer = this.createStageTimer("consumer_send_request");
    private final SimpleTimer consumerGetConnectionTimer = this.createStageTimer("consumer_get_connection");
    private final SimpleTimer consumerWriteToBufTimer = this.createStageTimer("consumer_write_to_buf");
    private final SimpleTimer consumerWaitResponseTimer;
    private final SimpleTimer consumerWakeConsumerTimer = this.createStageTimer("consumer_wake_consumer");
    private final SimpleTimer clientFiltersResponseTimer = this.createStageTimer("client_filters_response");

    public ConsumerInvocationMeter(Id id) {
        super(id);
        this.consumerWaitResponseTimer = this.createStageTimer("consumer_wait_response");
    }

    @Override
    public void onInvocationFinish(InvocationFinishEvent event) {
        super.onInvocationFinish(event);
        InvocationStageTrace invocationStageTrace = event.getInvocation().getInvocationStageTrace();
        this.clientFiltersRequestTimer.record((long)invocationStageTrace.calcClientFiltersRequestTime());
        this.consumerSendRequestTimer.record((long)invocationStageTrace.calcSendRequestTime());
        this.consumerGetConnectionTimer.record((long)invocationStageTrace.calcGetConnectionTime());
        this.consumerWriteToBufTimer.record((long)invocationStageTrace.calcWriteToBufferTime());
        this.consumerWaitResponseTimer.record((long)invocationStageTrace.calcReceiveResponseTime());
        this.consumerWakeConsumerTimer.record((long)invocationStageTrace.calcWakeConsumer());
        this.clientFiltersResponseTimer.record((long)invocationStageTrace.calcClientFiltersResponseTime());
    }

    @Override
    public void calcMeasurements(List<Measurement> measurements, long msNow, long secondInterval) {
        super.calcMeasurements(measurements, msNow, secondInterval);
        this.clientFiltersRequestTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.consumerSendRequestTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.consumerGetConnectionTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.consumerWriteToBufTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.consumerWaitResponseTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.consumerWakeConsumerTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.clientFiltersResponseTimer.calcMeasurements(measurements, msNow, secondInterval);
    }
}

