/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.util.Config;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.shenyu.admin.config.properties.DeploymentProperties;
import org.apache.shenyu.admin.scale.scaler.KubernetesScaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DeploymentProperties.class})
public class KubernetesConfiguration {
    private final Logger logger = LoggerFactory.getLogger(KubernetesConfiguration.class);

    @Bean
    @ConditionalOnProperty(value={"shenyu.k8s.scale.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={DeploymentProperties.class})
    public AppsV1Api apiClient(DeploymentProperties deploymentProperties) {
        try {
            ApiClient client = Config.fromToken((String)deploymentProperties.getApiServer(), (String)deploymentProperties.getToken(), (boolean)false);
            try (FileInputStream caCertStream = new FileInputStream(deploymentProperties.getCaCertPath());){
                client.setSslCaCert((InputStream)caCertStream);
            }
            return new AppsV1Api(client);
        }
        catch (IOException e) {
            this.logger.error("kubernetes apiClient create error", (Throwable)e);
            return null;
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={AppsV1Api.class, DeploymentProperties.class})
    public KubernetesScaler kubernetesScaler(Optional<AppsV1Api> appsV1Api, DeploymentProperties deploymentProperties) {
        return new KubernetesScaler(appsV1Api, deploymentProperties);
    }
}

