/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.cookie;

import com.linecorp.armeria.client.cookie.CookiePolicy;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.internal.client.PublicSuffix;
import io.netty.util.NetUtil;
import java.net.URI;
import java.util.Objects;

final class AcceptOriginCookiePolicy
implements CookiePolicy {
    private static final AcceptOriginCookiePolicy INSTANCE = new AcceptOriginCookiePolicy();

    static AcceptOriginCookiePolicy get() {
        return INSTANCE;
    }

    private AcceptOriginCookiePolicy() {
    }

    @Override
    public boolean accept(URI uri, Cookie cookie) {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(cookie, "cookie");
        String domain = cookie.domain();
        String host = uri.getHost();
        if (domain == null || host == null) {
            return false;
        }
        if (PublicSuffix.get().isPublicSuffix(domain)) {
            return false;
        }
        if (domain.equalsIgnoreCase(host)) {
            return true;
        }
        return host.endsWith(domain) && host.charAt(host.length() - domain.length() - 1) == '.' && !NetUtil.isValidIpV4Address(host) && !NetUtil.isValidIpV6Address(host);
    }
}

