/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.datacarrier.consumer;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.QueueBuffer;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;

public class ConsumerThread<T>
extends Thread {
    private volatile boolean running;
    private IConsumer<T> consumer;
    private List<DataSource> dataSources;
    private long consumeCycle;

    ConsumerThread(String threadName, IConsumer<T> consumer, long consumeCycle) {
        super(threadName);
        this.consumer = consumer;
        this.running = false;
        this.dataSources = new ArrayList<DataSource>(1);
        this.consumeCycle = consumeCycle;
    }

    void addDataSource(QueueBuffer<T> sourceBuffer) {
        this.dataSources.add(new DataSource(sourceBuffer));
    }

    @Override
    public void run() {
        this.running = true;
        ArrayList consumeList = new ArrayList(1500);
        while (this.running) {
            if (this.consume(consumeList)) continue;
            try {
                Thread.sleep(this.consumeCycle);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.consume(consumeList);
        this.consumer.onExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean consume(List<T> consumeList) {
        for (DataSource dataSource : this.dataSources) {
            dataSource.obtain(consumeList);
        }
        if (!consumeList.isEmpty()) {
            try {
                this.consumer.consume(consumeList);
            }
            catch (Throwable t) {
                this.consumer.onError(consumeList, t);
            }
            finally {
                consumeList.clear();
            }
            return true;
        }
        this.consumer.nothingToConsume();
        return false;
    }

    void shutdown() {
        this.running = false;
    }

    class DataSource {
        private QueueBuffer<T> sourceBuffer;

        DataSource(QueueBuffer<T> sourceBuffer) {
            this.sourceBuffer = sourceBuffer;
        }

        void obtain(List<T> consumeList) {
            this.sourceBuffer.obtain(consumeList);
        }
    }
}

