/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.InheritAnalysisRules;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.ToBinary;
import org.apache.spark.sql.catalyst.expressions.TryEval;
import org.apache.spark.sql.catalyst.expressions.TryToBinary$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str[, fmt]) - This is a special version of `to_binary` that performs the same operation, but returns a NULL value instead of raising an error if the conversion cannot be performed.", examples="\n    Examples:\n      > SELECT _FUNC_('abc', 'utf-8');\n       abc\n      > select _FUNC_('a!', 'base64');\n       NULL\n      > select _FUNC_('abc', 'invalidFormat');\n       NULL\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001B\u0010!\u00016B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005]!AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011!\u0019\u0006A!f\u0001\n\u0003Y\u0005\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011\u0002\u0018\t\u000bU\u0003A\u0011\u0001,\t\u000bU\u0003A\u0011A.\t\u000bU\u0003A\u0011A/\t\u000b\u0005\u0004A\u0011\t2\t\u000b-\u0004A\u0011\t7\t\u000bA\u0004A\u0011K9\t\u000fQ\u0004\u0011\u0011!C\u0001k\"9\u0011\u0010AI\u0001\n\u0003Q\b\"CA\u0006\u0001E\u0005I\u0011AA\u0007\u0011!\t\t\u0002AI\u0001\n\u0003Q\b\"CA\n\u0001\u0005\u0005I\u0011IA\u000b\u0011%\t)\u0003AA\u0001\n\u0003\t9\u0003C\u0005\u00020\u0001\t\t\u0011\"\u0001\u00022!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0013q\b\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001fB\u0011\"!\u0017\u0001\u0003\u0003%\t%a\u0017\t\u0013\u0005}\u0003!!A\u0005B\u0005\u0005t!CACA\u0005\u0005\t\u0012AAD\r!y\u0002%!A\t\u0002\u0005%\u0005BB+\u001a\t\u0003\t\t\u000bC\u0005\u0002$f\t\t\u0011\"\u0012\u0002&\"I\u0011qU\r\u0002\u0002\u0013\u0005\u0015\u0011\u0016\u0005\n\u0003cK\u0012\u0011!CA\u0003gC\u0011\"!1\u001a\u0003\u0003%I!a1\u0003\u0017Q\u0013\u0018\u0010V8CS:\f'/\u001f\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M1\u0001A\f\u001a6qy\u0002\"a\f\u0019\u000e\u0003\u0001J!!\r\u0011\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00020g%\u0011A\u0007\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00020m%\u0011q\u0007\t\u0002\u0015\u0013:DWM]5u\u0003:\fG._:jgJ+H.Z:\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011qh\u0012\b\u0003\u0001\u0016s!!\u0011#\u000e\u0003\tS!a\u0011\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014B\u0001$;\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001S%\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0019S\u0014\u0001B3yaJ,\u0012AL\u0001\u0006Kb\u0004(\u000fI\u0001\u0007M>\u0014X.\u0019;\u0016\u0003=\u00032!\u000f)/\u0013\t\t&H\u0001\u0004PaRLwN\\\u0001\bM>\u0014X.\u0019;!\u0003-\u0011X\r\u001d7bG\u0016lWM\u001c;\u0002\u0019I,\u0007\u000f\\1dK6,g\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\u00119\u0006,\u0017.\u0011\u0005=\u0002\u0001\"\u0002&\b\u0001\u0004q\u0003\"B'\b\u0001\u0004y\u0005\"B*\b\u0001\u0004qCCA,]\u0011\u0015Q\u0005\u00021\u0001/)\r9fl\u0018\u0005\u0006\u0015&\u0001\rA\f\u0005\u0006A&\u0001\rAL\u0001\u0011M>\u0014X.\u0019;FqB\u0014Xm]:j_:\f!\u0002\u001d:fiRLh*Y7f+\u0005\u0019\u0007C\u00013i\u001d\t)g\r\u0005\u0002Bu%\u0011qMO\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002hu\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0016\u00035\u00042a\u00108/\u0013\ty\u0017JA\u0002TKF\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGC\u0001\u0018s\u0011\u0015\u0019H\u00021\u0001/\u0003!qWm^\"iS2$\u0017\u0001B2paf$Ba\u0016<xq\"9!*\u0004I\u0001\u0002\u0004q\u0003bB'\u000e!\u0003\u0005\ra\u0014\u0005\b'6\u0001\n\u00111\u0001/\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001f\u0016\u0003]q\\\u0013! \t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0002;\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0013y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\bU\tyE0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\t1\fgn\u001a\u0006\u0003\u0003C\tAA[1wC&\u0019\u0011.a\u0007\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005%\u0002cA\u001d\u0002,%\u0019\u0011Q\u0006\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005M\u0012\u0011\b\t\u0004s\u0005U\u0012bAA\u001cu\t\u0019\u0011I\\=\t\u0013\u0005m2#!AA\u0002\u0005%\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002BA1\u00111IA%\u0003gi!!!\u0012\u000b\u0007\u0005\u001d#(\u0001\u0006d_2dWm\u0019;j_:LA!a\u0013\u0002F\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t&a\u0016\u0011\u0007e\n\u0019&C\u0002\u0002Vi\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002<U\t\t\u00111\u0001\u00024\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9\"!\u0018\t\u0013\u0005mb#!AA\u0002\u0005%\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002R\u0005\r\u0004\"CA\u001e/\u0005\u0005\t\u0019AA\u001aQM\u0001\u0011qMA7\u0003_\n\u0019(!\u001e\u0002z\u0005m\u0014qPAA!\ry\u0013\u0011N\u0005\u0004\u0003W\u0002#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003c\n\u0011qO0G+:\u001bu\fK:uenc\u0003EZ7u;&\u0002S\u0006\t+iSN\u0004\u0013n\u001d\u0011bAM\u0004XmY5bY\u00022XM]:j_:\u0004sN\u001a\u0011ai>|&-\u001b8bef\u0004\u0007\u0005\u001e5bi\u0002\u0002XM\u001d4pe6\u001c\b\u0005\u001e5fAM\fW.\u001a\u0011pa\u0016\u0014\u0018\r^5p]2\u0002#-\u001e;!e\u0016$XO\u001d8tA\u0005\u0004c*\u0016'MAY\fG.^3!S:\u001cH/Z1eA=4\u0007E]1jg&tw\rI1oA\u0015\u0014(o\u001c:!S\u001a\u0004C\u000f[3!G>tg/\u001a:tS>t\u0007eY1o]>$\bEY3!a\u0016\u0014hm\u001c:nK\u0012t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005]\u0014!a\u0019\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n'mY\u0014-A\u001d*HOZ\u00179O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u00192d\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aX\r\\3di\u0002zf)\u0016(D?\":\u0013-I\u0014-A\u001d\u0012\u0017m]37i\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004e]3mK\u000e$\be\u0018$V\u001d\u000e{\u0006fJ1cG\u001eb\u0003eJ5om\u0006d\u0017\u000e\u001a$pe6\fGoJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QP\u0001\u0006g9\u001ad\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0007\u000bAb\u001d;sS:<wLZ;oGN\f1\u0002\u0016:z)>\u0014\u0015N\\1ssB\u0011q&G\n\u00063\u0005-\u0015q\u0013\t\t\u0003\u001b\u000b\u0019JL(//6\u0011\u0011q\u0012\u0006\u0004\u0003#S\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003+\u000byIA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!!'\u0002 6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by\"\u0001\u0002j_&\u0019\u0001*a'\u0015\u0005\u0005\u001d\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0011!B1qa2LHcB,\u0002,\u00065\u0016q\u0016\u0005\u0006\u0015r\u0001\rA\f\u0005\u0006\u001br\u0001\ra\u0014\u0005\u0006'r\u0001\rAL\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t),!0\u0011\te\u0002\u0016q\u0017\t\u0007s\u0005eff\u0014\u0018\n\u0007\u0005m&H\u0001\u0004UkBdWm\r\u0005\t\u0003\u007fk\u0012\u0011!a\u0001/\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u0015\u0007\u0003BA\r\u0003\u000fLA!!3\u0002\u001c\t1qJ\u00196fGR\u0004")
public class TryToBinary
extends Expression
implements RuntimeReplaceable,
InheritAnalysisRules,
Serializable {
    private final Expression expr;
    private final Option<Expression> format;
    private final Expression replacement;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(TryToBinary x$0) {
        return TryToBinary$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, TryToBinary> tupled() {
        return TryToBinary$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, TryToBinary>>> curried() {
        return TryToBinary$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return InheritAnalysisRules.child$(this);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return InheritAnalysisRules.flatArguments$(this);
    }

    @Override
    public String makeSQLString(Seq<String> childrenSQL) {
        return InheritAnalysisRules.makeSQLString$(this, childrenSQL);
    }

    @Override
    public final String sql() {
        return InheritAnalysisRules.sql$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        TryToBinary tryToBinary = this;
        synchronized (tryToBinary) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        TryToBinary tryToBinary = this;
        synchronized (tryToBinary) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression expr() {
        return this.expr;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression replacement() {
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "try_to_binary";
    }

    @Override
    public Seq<Expression> parameters() {
        Expression expression = this.expr();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public TryToBinary copy(Expression expr, Option<Expression> format, Expression replacement) {
        return new TryToBinary(expr, format, replacement);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.replacement();
    }

    @Override
    public String productPrefix() {
        return "TryToBinary";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.expr();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return this.replacement();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TryToBinary;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "format";
            }
            case 2: {
                return "replacement";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TryToBinary)) return false;
        boolean bl = true;
        if (!bl) return false;
        TryToBinary tryToBinary = (TryToBinary)x$1;
        Expression expression = this.expr();
        Expression expression2 = tryToBinary.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = tryToBinary.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.replacement();
        Expression expression4 = tryToBinary.replacement();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!tryToBinary.canEqual(this)) return false;
        return true;
    }

    public TryToBinary(Expression expr, Option<Expression> format, Expression replacement) {
        this.expr = expr;
        this.format = format;
        this.replacement = replacement;
        RuntimeReplaceable.$init$(this);
        UnaryLike.$init$(this);
        InheritAnalysisRules.$init$(this);
        Statics.releaseFence();
    }

    public TryToBinary(Expression expr) {
        this(expr, (Option<Expression>)None$.MODULE$, new TryEval(new ToBinary(expr, (Option<Expression>)None$.MODULE$, true)));
    }

    public TryToBinary(Expression expr, Expression formatExpression) {
        this(expr, (Option<Expression>)new Some((Object)formatExpression), new TryEval(new ToBinary(expr, (Option<Expression>)new Some((Object)formatExpression), true)));
    }
}

