/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\u0010 \u00011BQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004P\u0001\u0001\u0006Ia\u0010\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019\t\u0007\u0001)A\u0005%\"9!\r\u0001a\u0001\n\u0013\u0019\u0007bB7\u0001\u0001\u0004%IA\u001c\u0005\u0007i\u0002\u0001\u000b\u0015\u00023\t\u000bU\u0004A\u0011\u0002<\t\u0011\u0005E\u0001\u0001\"\u0001\"\u0003'A\u0001\"!\t\u0001\t\u0003\t\u00131\u0005\u0005\t\u0003S\u0001A\u0011A\u0011\u0002,!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002bBA\"\u0001\u0011%\u0011Q\t\u0005\n\u0003'\u0002\u0011\u0013!C\u0005\u0003+Bq!a\u001b\u0001\t\u0013\ti\u0007C\u0005\u0002v\u0001\t\n\u0011\"\u0003\u0002V!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004\"CA@\u0001E\u0005I\u0011AA+\u0011!\t\t\t\u0001C\u0001C\u0005\r\u0005bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u00037\u0003A\u0011AAD\u0011\u001d\ti\n\u0001C\u0005\u0003\u0007C\u0001\"a(\u0001\t\u0003\t\u0013\u0011\u0015\u0005\b\u0003?\u0003A\u0011BAW\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!!2\u0001\t\u0013\t9\r\u0003\u0005\u0002L\u0002!\t!IAB\u0011!\ti\r\u0001C\u0001C\u0005='AG*qCJ\\7i\u001c8oK\u000e$8+Z:tS>tW*\u00198bO\u0016\u0014(B\u0001\u0011\"\u0003\u001d\u0019XM\u001d<jG\u0016T!AI\u0012\u0002\u000f\r|gN\\3di*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!t'D\u00016\u0015\t1T%\u0001\u0005j]R,'O\\1m\u0013\tATGA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Y\u0004C\u0001\u001f\u0001\u001b\u0005y\u0012\u0001D:fgNLwN\\*u_J,W#A \u0011\t\u0001;\u0015\nT\u0007\u0002\u0003*\u0011!iQ\u0001\u000bG>t7-\u001e:sK:$(B\u0001#F\u0003\u0011)H/\u001b7\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001*\u0011\u0002\u000e\u0007>t7-\u001e:sK:$X*\u00199\u0011\u0005qR\u0015BA& \u0005)\u0019Vm]:j_:\\U-\u001f\t\u0003y5K!AT\u0010\u0003\u001bM+7o]5p]\"{G\u000eZ3s\u00035\u0019Xm]:j_:\u001cFo\u001c:fA\u0005\u00192\r\\8tK\u0012\u001cVm]:j_:\u001c8)Y2iKV\t!\u000b\u0005\u0003T9&sV\"\u0001+\u000b\u0005U3\u0016!B2bG\",'BA,Y\u0003\u0019\u0019w.\\7p]*\u0011\u0011LW\u0001\u0007O>|w\r\\3\u000b\u0003m\u000b1aY8n\u0013\tiFKA\u0003DC\u000eDW\r\u0005\u0002=?&\u0011\u0001m\b\u0002\u0012'\u0016\u001c8/[8o\u0011>dG-\u001a:J]\u001a|\u0017\u0001F2m_N,GmU3tg&|gn]\"bG\",\u0007%A\ttG\",G-\u001e7fI\u0016CXmY;u_J,\u0012\u0001\u001a\t\u0004K\"TW\"\u00014\u000b\u0005\u001d\f\u0015AB1u_6L7-\u0003\u0002jM\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002AW&\u0011A.\u0011\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!F:dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;pe~#S-\u001d\u000b\u0003_J\u0004\"A\f9\n\u0005E|#\u0001B+oSRDqa]\u0004\u0002\u0002\u0003\u0007A-A\u0002yIE\n!c]2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8sA\u0005\tb/\u00197jI\u0006$XmU3tg&|g.\u00133\u0015\u000b=<\u00180!\u0004\t\u000baL\u0001\u0019A%\u0002\u0007-,\u0017\u0010C\u0003{\u0013\u0001\u000710A\u0006tKN\u001c\u0018n\u001c8V+&#\u0005c\u0001?\u0002\b9\u0019Q0a\u0001\u0011\u0005y|S\"A@\u000b\u0007\u0005\u00051&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000by\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\n\u0005-!AB*ue&twMC\u0002\u0002\u0006=Ba!a\u0004\n\u0001\u0004Y\u0018a\u00079sKZLw.^:ms>\u00137/\u001a:wK\u0012\u001cVm]:j_:LE-\u0001\u000ehKR|%o\u0011:fCR,\u0017j]8mCR,GmU3tg&|g\u000eF\u0003M\u0003+\t9\u0002C\u0003y\u0015\u0001\u0007\u0011\nC\u0004\u0002\u001a)\u0001\r!a\u0007\u00029A\u0014XM^5pkNd\u0017p\u00142tKJ4X\rZ*fgN\u001c\u0018n\u001c8JIB!a&!\b|\u0013\r\tyb\f\u0002\u0007\u001fB$\u0018n\u001c8\u0002%\u001d,G/S:pY\u0006$X\rZ*fgNLwN\u001c\u000b\u0006\u0019\u0006\u0015\u0012q\u0005\u0005\u0006q.\u0001\r!\u0013\u0005\b\u00033Y\u0001\u0019AA\u000e\u0003m9W\r^%t_2\fG/\u001a3TKN\u001c\u0018n\u001c8JMB\u0013Xm]3oiR!\u0011QFA\u0018!\u0011q\u0013Q\u0004'\t\u000bad\u0001\u0019A%\u0002\u0015\u001d,GoU3tg&|g\u000eF\u0003M\u0003k\t9\u0004C\u0003y\u001b\u0001\u0007\u0011\nC\u0004\u0002:5\u0001\r!a\u000f\u0002\u000f\u0011,g-Y;miB)a&!\b\u0002>A!a&a\u0010M\u0013\r\t\te\f\u0002\n\rVt7\r^5p]B\n1C]3n_Z,7+Z:tS>t\u0007j\u001c7eKJ$b!!\f\u0002H\u0005%\u0003\"\u0002=\u000f\u0001\u0004I\u0005\"CA&\u001dA\u0005\t\u0019AA'\u00039\tG\u000e\\8x%\u0016\u001cwN\u001c8fGR\u00042ALA(\u0013\r\t\tf\f\u0002\b\u0005>|G.Z1o\u0003u\u0011X-\\8wKN+7o]5p]\"{G\u000eZ3sI\u0011,g-Y;mi\u0012\u0012TCAA,U\u0011\ti%!\u0017,\u0005\u0005m\u0003\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001a0\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\nyFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQc\u001d5vi\u0012|wO\\*fgNLwN\u001c%pY\u0012,'\u000fF\u0003p\u0003_\n\u0019\b\u0003\u0004\u0002rA\u0001\r\u0001T\u0001\u000eg\u0016\u001c8/[8o\u0011>dG-\u001a:\t\u0013\u0005-\u0003\u0003%AA\u0002\u00055\u0013aH:ikR$wn\u001e8TKN\u001c\u0018n\u001c8I_2$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005a1\r\\8tKN+7o]5p]R)q.a\u001f\u0002~!)\u0001P\u0005a\u0001\u0013\"I\u00111\n\n\u0011\u0002\u0003\u0007\u0011QJ\u0001\u0017G2|7/Z*fgNLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u0005A1\u000f[;uI><h\u000eF\u0001p\u0003Ia\u0017n\u001d;BGRLg/Z*fgNLwN\\:\u0016\u0005\u0005%\u0005#BAF\u0003+sf\u0002BAG\u0003#s1A`AH\u0013\u0005\u0001\u0014bAAJ_\u00059\u0001/Y2lC\u001e,\u0017\u0002BAL\u00033\u00131aU3r\u0015\r\t\u0019jL\u0001\u0013Y&\u001cHo\u00117pg\u0016$7+Z:tS>t7/\u0001\ftG\",G-\u001e7f!\u0016\u0014\u0018n\u001c3jG\u000eCWmY6t\u0003M\u0001XM]5pI&\u001cW*Y5oi\u0016t\u0017M\\2f)\ry\u00171\u0015\u0005\b\u0003KC\u0002\u0019AAT\u0003a!WMZ1vYRLe.Y2uSZ,G+[7f_V$Xj\u001d\t\u0004]\u0005%\u0016bAAV_\t!Aj\u001c8h)\u0015y\u0017qVAY\u0011\u001d\t)+\u0007a\u0001\u0003OCq!a-\u001a\u0001\u0004\ti%A\njO:|'/Z\"vgR|W\u000eV5nK>,H/\u0001\noK^L5o\u001c7bi\u0016$7+Z:tS>tGCAA]!\u0011\tY,!1\u000e\u0005\u0005u&bAA`G\u000591\r\\1tg&\u001c\u0017\u0002BAb\u0003{\u0013Ab\u00159be.\u001cVm]:j_:\fQC^1mS\u0012\fG/Z*fgNLwN\\\"sK\u0006$X\rF\u0002p\u0003\u0013DQ\u0001_\u000eA\u0002%\u000bQ#\u001b8wC2LG-\u0019;f\u00032d7+Z:tS>t7/\u0001\u000bqkR\u001cVm]:j_:4uN\u001d+fgRLgn\u001a\u000b\u0004_\u0006E\u0007BBA9;\u0001\u0007A\n")
public class SparkConnectSessionManager
implements Logging {
    private final ConcurrentMap<SessionKey, SessionHolder> sessionStore;
    private final Cache<SessionKey, SessionHolderInfo> closedSessionsCache;
    private AtomicReference<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<SessionKey, SessionHolder> sessionStore() {
        return this.sessionStore;
    }

    private Cache<SessionKey, SessionHolderInfo> closedSessionsCache() {
        return this.closedSessionsCache;
    }

    private AtomicReference<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void scheduledExecutor_$eq(AtomicReference<ScheduledExecutorService> x$1) {
        this.scheduledExecutor = x$1;
    }

    private void validateSessionId(SessionKey key, String sessionUUID, String previouslyObservedSessionId) {
        String string = sessionUUID;
        String string2 = previouslyObservedSessionId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CHANGED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public SessionHolder getOrCreateIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.validateSessionCreate(key);
            SessionHolder holder = new SessionHolder(key.userId(), key.sessionId(), this.newIsolatedSession());
            holder.initializeSession();
            return holder;
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public SessionHolder getIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Session not found: " + key);
            if (this.closedSessionsCache().getIfPresent(key) != null) {
                throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
            }
            throw new SparkSQLException("INVALID_HANDLE.SESSION_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public Option<SessionHolder> getIsolatedSessionIfPresent(SessionKey key) {
        return Option$.MODULE$.apply((Object)this.getSession(key, (Option<Function0<SessionHolder>>)None$.MODULE$));
    }

    private SessionHolder getSession(SessionKey key, Option<Function0<SessionHolder>> option) {
        SessionHolder session;
        block4: {
            SessionHolder sessionHolder;
            this.schedulePeriodicChecks();
            Option<Function0<SessionHolder>> option2 = option;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Function0 callable = (Function0)some.value();
                sessionHolder = this.sessionStore().computeIfAbsent(key, x$1 -> (SessionHolder)callable.apply());
            } else if (None$.MODULE$.equals(option2)) {
                sessionHolder = (SessionHolder)this.sessionStore().get(key);
            } else {
                throw new MatchError(option2);
            }
            session = sessionHolder;
            if (session == null) break block4;
            session.updateAccessTime();
        }
        return session;
    }

    private Option<SessionHolder> removeSessionHolder(SessionKey key, boolean allowReconnect) {
        None$ sessionHolder = None$.MODULE$;
        sessionHolder = Option$.MODULE$.apply(this.sessionStore().get(key));
        sessionHolder.foreach((Function1 & Serializable)s2 -> {
            block0: {
                if (allowReconnect) break block0;
                this.closedSessionsCache().put(s2.key(), s2.getSessionHolderInfo());
            }
            return (SessionHolder)this.sessionStore().remove(key);
        });
        return sessionHolder;
    }

    private boolean removeSessionHolder$default$2() {
        return false;
    }

    private void shutdownSessionHolder(SessionHolder sessionHolder, boolean allowReconnect) {
        sessionHolder.close();
        if (!allowReconnect) {
            this.closedSessionsCache().put(sessionHolder.key(), sessionHolder.getSessionHolderInfo());
            return;
        }
    }

    public void closeSession(SessionKey key, boolean allowReconnect) {
        Option<SessionHolder> sessionHolder = this.removeSessionHolder(key, allowReconnect);
        sessionHolder.foreach((Function1 & Serializable)x$2 -> {
            this.shutdownSessionHolder(x$2, allowReconnect);
            return BoxedUnit.UNIT;
        });
    }

    public boolean closeSession$default$2() {
        return false;
    }

    public void shutdown() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAndSet(null);
        if (executor != null) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
        }
        this.sessionStore().clear();
        this.closedSessionsCache().invalidateAll();
    }

    private boolean shutdownSessionHolder$default$2() {
        return false;
    }

    public Seq<SessionHolderInfo> listActiveSessions() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.sessionStore().values()).asScala().map((Function1 & Serializable)x$3 -> x$3.getSessionHolderInfo())).toSeq();
    }

    public Seq<SessionHolderInfo> listClosedSessions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.closedSessionsCache().asMap()).asScala().values().toSeq();
    }

    private void schedulePeriodicChecks() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAcquire();
        if (executor == null) {
            executor = Executors.newSingleThreadScheduledExecutor();
            if (this.scheduledExecutor().compareAndExchangeRelease(null, executor) == null) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of expired sessions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)interval))})))));
                executor.scheduleAtFixedRate(() -> {
                    try {
                        long defaultInactiveTimeoutMs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT()));
                        this.periodicMaintenance(defaultInactiveTimeoutMs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public void periodicMaintenance(long defaultInactiveTimeoutMs) {
        this.periodicMaintenance(defaultInactiveTimeoutMs, false);
    }

    private void periodicMaintenance(long defaultInactiveTimeoutMs, boolean ignoreCustomTimeout) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectSessionManager maintenance.");
        long nowMs = System.currentTimeMillis();
        this.sessionStore().forEach((x$4, sessionHolder) -> {
            SessionHolderInfo info = sessionHolder.getSessionHolderInfo();
            if (SparkConnectSessionManager.shouldExpire$1(info, nowMs, ignoreCustomTimeout, defaultInactiveTimeoutMs)) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found session ", " that expired "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_HOLD_INFO$.MODULE$, (Object)info)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and will be closed."}))).log((Seq)Nil$.MODULE$))));
                this.removeSessionHolder(info.key(), this.removeSessionHolder$default$2());
                try {
                    this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception closing session", throwable2);
                    }
                    throw throwable;
                }
                return;
            }
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectSessionManager maintenance.");
    }

    private SparkSession newIsolatedSession() {
        SparkSession active = SparkSession$.MODULE$.active();
        if (active.sparkContext().isStopped()) {
            Predef$.MODULE$.assert(SparkSession$.MODULE$.getDefaultSession().nonEmpty());
            return ((SparkSession)SparkSession$.MODULE$.getDefaultSession().get()).newSession();
        }
        return active.newSession();
    }

    private void validateSessionCreate(SessionKey key) {
        try {
            UUID.fromString(key.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
        if (this.closedSessionsCache().getIfPresent(key) != null) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public void invalidateAllSessions() {
        this.sessionStore().forEach((key, sessionHolder) -> {
            this.removeSessionHolder((SessionKey)key, this.removeSessionHolder$default$2());
            this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
        });
        this.closedSessionsCache().invalidateAll();
    }

    public void putSessionForTesting(SessionHolder sessionHolder) {
        this.sessionStore().put(sessionHolder.key(), sessionHolder);
    }

    private static final boolean shouldExpire$1(SessionHolderInfo info, long nowMs, boolean ignoreCustomTimeout$1, long defaultInactiveTimeoutMs$1) {
        long timeoutMs = info.customInactiveTimeoutMs().isDefined() && !ignoreCustomTimeout$1 ? BoxesRunTime.unboxToLong((Object)info.customInactiveTimeoutMs().get()) : defaultInactiveTimeoutMs$1;
        return timeoutMs != -1L && info.lastAccessTimeMs() + timeoutMs <= nowMs;
    }

    public SparkConnectSessionManager() {
        Logging.$init$((Logging)this);
        this.sessionStore = new ConcurrentHashMap<SessionKey, SessionHolder>();
        this.closedSessionsCache = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE()))).build();
        this.scheduledExecutor = new AtomicReference();
    }
}

