/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@Explain(displayName="Map Reduce Local Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, vectorization=Explain.Vectorization.SUMMARY_PATH)
public class MapredLocalWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork;
    private LinkedHashMap<String, FetchWork> aliasToFetchWork;
    private boolean inputFileChangeSensitive;
    private BucketMapJoinContext bucketMapjoinContext;
    private Path tmpPath;
    private String stageID;
    private Path tmpHDFSPath;
    private List<Operator<? extends OperatorDesc>> dummyParentOp;
    private Map<MapJoinOperator, List<Operator<? extends OperatorDesc>>> directFetchOp;
    private boolean hasStagedAlias;

    public MapredLocalWork() {
        this(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
        this.dummyParentOp = new ArrayList<Operator<? extends OperatorDesc>>();
        this.directFetchOp = new LinkedHashMap<MapJoinOperator, List<Operator<? extends OperatorDesc>>>();
    }

    public MapredLocalWork(LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork, LinkedHashMap<String, FetchWork> aliasToFetchWork) {
        this.aliasToWork = aliasToWork;
        this.aliasToFetchWork = aliasToFetchWork;
    }

    public MapredLocalWork(MapredLocalWork clone) {
        this.tmpPath = clone.tmpPath;
        this.inputFileChangeSensitive = clone.inputFileChangeSensitive;
    }

    public void setDummyParentOp(List<Operator<? extends OperatorDesc>> op) {
        this.dummyParentOp = op;
    }

    public List<Operator<? extends OperatorDesc>> getDummyParentOp() {
        return this.dummyParentOp;
    }

    @Explain(displayName="Alias -> Map Local Operator Tree", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public LinkedHashMap<String, Operator<? extends OperatorDesc>> getAliasToWork() {
        return this.aliasToWork;
    }

    public String getStageID() {
        return this.stageID;
    }

    public void setStageID(String stageID) {
        this.stageID = stageID;
    }

    public void setAliasToWork(LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork) {
        this.aliasToWork = aliasToWork;
    }

    @Explain(displayName="Alias -> Map Local Tables", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public LinkedHashMap<String, FetchWork> getAliasToFetchWork() {
        return this.aliasToFetchWork;
    }

    public void setAliasToFetchWork(LinkedHashMap<String, FetchWork> aliasToFetchWork) {
        this.aliasToFetchWork = aliasToFetchWork;
    }

    public boolean getInputFileChangeSensitive() {
        return this.inputFileChangeSensitive;
    }

    public void setInputFileChangeSensitive(boolean inputFileChangeSensitive) {
        this.inputFileChangeSensitive = inputFileChangeSensitive;
    }

    public void deriveExplainAttributes() {
        if (this.bucketMapjoinContext != null) {
            this.bucketMapjoinContext.deriveBucketMapJoinMapping();
        }
        for (FetchWork fetchWork : this.aliasToFetchWork.values()) {
            PlanUtils.configureInputJobPropertiesForStorageHandler(fetchWork.getTblDesc());
        }
    }

    @Explain(displayName="Bucket Mapjoin Context", explainLevels={Explain.Level.EXTENDED})
    public BucketMapJoinContext getBucketMapjoinContextExplain() {
        return this.bucketMapjoinContext != null && this.bucketMapjoinContext.getBucketFileNameMapping() != null ? this.bucketMapjoinContext : null;
    }

    public BucketMapJoinContext getBucketMapjoinContext() {
        return this.bucketMapjoinContext;
    }

    public void setBucketMapjoinContext(BucketMapJoinContext bucketMapjoinContext) {
        this.bucketMapjoinContext = bucketMapjoinContext;
    }

    public BucketMapJoinContext copyPartSpecMappingOnly() {
        if (this.bucketMapjoinContext != null && this.bucketMapjoinContext.getBigTablePartSpecToFileMapping() != null) {
            BucketMapJoinContext context = new BucketMapJoinContext();
            context.setBigTablePartSpecToFileMapping(this.bucketMapjoinContext.getBigTablePartSpecToFileMapping());
            return context;
        }
        return null;
    }

    public void setTmpPath(Path tmpPath) {
        this.tmpPath = tmpPath;
    }

    public Path getTmpPath() {
        return this.tmpPath;
    }

    public void setTmpHDFSPath(Path tmpPath) {
        this.tmpHDFSPath = tmpPath;
    }

    public Path getTmpHDFSPath() {
        return this.tmpHDFSPath;
    }

    public String getBucketFileName(String bigFileName) {
        if (!this.inputFileChangeSensitive || bigFileName == null || bigFileName.isEmpty()) {
            return "-";
        }
        String fileName = this.getFileName(bigFileName);
        if (this.bucketMapjoinContext != null) {
            fileName = this.bucketMapjoinContext.createFileName(bigFileName, fileName);
        }
        return fileName;
    }

    private String getFileName(String path) {
        int last_separator = path.lastIndexOf("/");
        if (last_separator < 0) {
            return path;
        }
        return path.substring(last_separator + 1);
    }

    public MapredLocalWork extractDirectWorks(Map<MapJoinOperator, List<Operator<? extends OperatorDesc>>> directWorks) {
        MapredLocalWork newLocalWork = new MapredLocalWork();
        newLocalWork.setTmpPath(this.tmpPath);
        newLocalWork.setInputFileChangeSensitive(this.inputFileChangeSensitive);
        Set<Operator<?>> validWorks = this.getDirectWorks(directWorks.values());
        if (validWorks.isEmpty()) {
            newLocalWork.setBucketMapjoinContext(this.copyPartSpecMappingOnly());
            return newLocalWork;
        }
        newLocalWork.directFetchOp = new HashMap<MapJoinOperator, List<Operator<? extends OperatorDesc>>>(directWorks);
        newLocalWork.aliasToWork = new LinkedHashMap();
        newLocalWork.aliasToFetchWork = new LinkedHashMap();
        HashMap<String, Operator<? extends OperatorDesc>> works = new HashMap<String, Operator<? extends OperatorDesc>>(this.aliasToWork);
        for (Map.Entry entry : works.entrySet()) {
            String alias = (String)entry.getKey();
            boolean notStaged = validWorks.contains(entry.getValue());
            newLocalWork.aliasToWork.put(alias, notStaged ? (Operator)this.aliasToWork.remove(alias) : null);
            newLocalWork.aliasToFetchWork.put(alias, notStaged ? (FetchWork)this.aliasToFetchWork.remove(alias) : null);
        }
        newLocalWork.setBucketMapjoinContext(this.getBucketMapjoinContext());
        return newLocalWork;
    }

    private Set<Operator<?>> getDirectWorks(Collection<List<Operator<?>>> values) {
        HashSet operators = new HashSet();
        for (List<Operator<?>> works : values) {
            for (Operator<?> work : works) {
                if (work == null) continue;
                operators.add(work);
            }
        }
        return operators;
    }

    public void setDirectFetchOp(Map<MapJoinOperator, List<Operator<? extends OperatorDesc>>> op) {
        this.directFetchOp = op;
    }

    public Map<MapJoinOperator, List<Operator<? extends OperatorDesc>>> getDirectFetchOp() {
        return this.directFetchOp;
    }

    public boolean hasStagedAlias() {
        return this.hasStagedAlias;
    }

    public void setHasStagedAlias(boolean hasStagedAlias) {
        this.hasStagedAlias = hasStagedAlias;
    }
}

