/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import org.apache.hadoop.hive.ql.io.ColumnarSplit;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitSizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnarSplitSizeEstimator
implements SplitSizeEstimator {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnarSplitSizeEstimator.class);
    private static final boolean isDebugEnabled = LOG.isDebugEnabled();

    public long getEstimatedSize(InputSplit inputSplit) throws IOException {
        InputSplit innerSplit;
        long colProjSize = inputSplit.getLength();
        if (inputSplit instanceof ColumnarSplit) {
            colProjSize = ((ColumnarSplit)inputSplit).getColumnarProjectionSize();
            if (isDebugEnabled) {
                LOG.debug("Estimated column projection size: " + colProjSize);
            }
        } else if (inputSplit instanceof HiveInputFormat.HiveInputSplit && (innerSplit = ((HiveInputFormat.HiveInputSplit)inputSplit).getInputSplit()) instanceof ColumnarSplit) {
            colProjSize = ((ColumnarSplit)innerSplit).getColumnarProjectionSize();
            if (isDebugEnabled) {
                LOG.debug("Estimated column projection size: " + colProjSize);
            }
        }
        if (colProjSize <= 0L) {
            return Integer.MAX_VALUE;
        }
        return colProjSize;
    }
}

