/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetQuantileBase;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetQuantileFloat$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Extracts a single value from the quantiles sketch representing the\n    desired quantile given the input rank. The desired quantile can either be a single value\n    or an array. In the latter case, the function will return an array of results of equal\n    length to the input array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(kll_sketch_agg_float(col), 0.5) > 1 FROM VALUES (CAST(1.0 AS FLOAT)), (CAST(2.0 AS FLOAT)), (CAST(3.0 AS FLOAT)), (CAST(4.0 AS FLOAT)), (CAST(5.0 AS FLOAT)) tab(col);\n       true\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015I\b\u0001\"\u0011{\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA&\u0001\u0005\u0005I\u0011IA'\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0013qN\u0004\n\u0003'k\u0012\u0011!E\u0001\u0003+3\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u0013\u0005\u0007\u0013Z!\t!a,\t\u0013\u0005Ef#!A\u0005F\u0005M\u0006\"CA[-\u0005\u0005I\u0011QA\\\u0011%\tiLFA\u0001\n\u0003\u000by\fC\u0005\u0002RZ\t\t\u0011\"\u0003\u0002T\nI2\n\u001c7TW\u0016$8\r[$fiF+\u0018M\u001c;jY\u00164En\\1u\u0015\tqr$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0011\"\u0003!\u0019\u0017\r^1msN$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011\u0003\u0002\u0001,_U\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u00031-cGnU6fi\u000eDw)\u001a;Rk\u0006tG/\u001b7f\u0005\u0006\u001cX\r\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0004Qe>$Wo\u0019;\u0011\u0005YrdBA\u001c=\u001d\tA4(D\u0001:\u0015\tQ\u0014&\u0001\u0004=e>|GOP\u0005\u0002e%\u0011Q(M\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002>c\u0005!A.\u001a4u+\u0005\u0019\u0005C\u0001\u0017E\u0013\t)UD\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002L\u00196\u0003\"\u0001\f\u0001\t\u000b\u0005+\u0001\u0019A\"\t\u000b\u001d+\u0001\u0019A\"\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcA\"Q%\")\u0011K\u0002a\u0001\u0007\u00069a.Z<MK\u001a$\b\"B*\u0007\u0001\u0004\u0019\u0015\u0001\u00038foJKw\r\u001b;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001W!\t96L\u0004\u0002Y3B\u0011\u0001(M\u0005\u00035F\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!,M\u0001\u000f_V$\b/\u001e;ECR\fG+\u001f9f+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2\"\u0003\u0015!\u0018\u0010]3t\u0013\t)'M\u0001\u0005ECR\fG+\u001f9f\u0003QYG\u000e\\*lKR\u001c\u0007nR3u#V\fg\u000e^5mKR\u0019\u0001n\u001b;\u0011\u0005AJ\u0017B\u000162\u0005\r\te.\u001f\u0005\u0006Y&\u0001\r!\\\u0001\u0007[\u0016lwN]=\u0011\u00059\u0014X\"A8\u000b\u00051\u0004(BA9&\u00031!\u0017\r^1tW\u0016$8\r[3t\u0013\t\u0019xN\u0001\u0004NK6|'/\u001f\u0005\u0006k&\u0001\rA^\u0001\u0005e\u0006t7\u000e\u0005\u00021o&\u0011\u00010\r\u0002\u0007\t>,(\r\\3\u0002+-dGnU6fi\u000eDw)\u001a;Rk\u0006tG/\u001b7fgR\u00191P`@\u0011\u0007Ab\b.\u0003\u0002~c\t)\u0011I\u001d:bs\")AN\u0003a\u0001[\"9\u0011\u0011\u0001\u0006A\u0002\u0005\r\u0011!\u0002:b].\u001c\bc\u0001\u0019}m\u0006!1m\u001c9z)\u0015Y\u0015\u0011BA\u0006\u0011\u001d\t5\u0002%AA\u0002\rCqaR\u0006\u0011\u0002\u0003\u00071)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E!fA\"\u0002\u0014-\u0012\u0011Q\u0003\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003%)hn\u00195fG.,GMC\u0002\u0002 E\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019#!\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\t1\fgn\u001a\u0006\u0003\u0003k\tAA[1wC&\u0019A,a\f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0002c\u0001\u0019\u0002@%\u0019\u0011\u0011I\u0019\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007!\f9\u0005C\u0005\u0002JA\t\t\u00111\u0001\u0002>\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0014\u0011\u000b\u0005E\u0013q\u000b5\u000e\u0005\u0005M#bAA+c\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00131\u000b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002`\u0005\u0015\u0004c\u0001\u0019\u0002b%\u0019\u00111M\u0019\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\n\n\u0002\u0002\u0003\u0007\u0001.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0016\u0003WB\u0011\"!\u0013\u0014\u0003\u0003\u0005\r!!\u0010\u0002\r\u0015\fX/\u00197t)\u0011\ty&!\u001d\t\u0011\u0005%C#!AA\u0002!D3\u0003AA;\u0003w\ni(!!\u0002\u0004\u0006\u001d\u0015\u0011RAG\u0003\u001f\u00032\u0001LA<\u0013\r\tI(\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty(\u0001B8\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b7fMRd\u0003E]5hQRL\u0003%\f\u0011FqR\u0014\u0018m\u0019;tA\u0005\u00043/\u001b8hY\u0016\u0004c/\u00197vK\u00022'o\\7!i\",\u0007%];b]RLG.Z:!g.,Go\u00195!e\u0016\u0004(/Z:f]RLgn\u001a\u0011uQ\u0016T\u0001\u0005\t\u0011!I\u0016\u001c\u0018N]3eAE,\u0018M\u001c;jY\u0016\u0004s-\u001b<f]\u0002\"\b.\u001a\u0011j]B,H\u000f\t:b].t\u0003\u0005\u00165fA\u0011,7/\u001b:fI\u0002\nX/\u00198uS2,\u0007eY1oA\u0015LG\u000f[3sA\t,\u0007%\u0019\u0011tS:<G.\u001a\u0011wC2,XM\u0003\u0011!A\u0001z'\u000fI1oA\u0005\u0014(/Y=/A%s\u0007\u0005\u001e5fA1\fG\u000f^3sA\r\f7/\u001a\u0017!i\",\u0007EZ;oGRLwN\u001c\u0011xS2d\u0007E]3ukJt\u0007%\u00198!CJ\u0014\u0018-\u001f\u0011pM\u0002\u0012Xm];miN\u0004sN\u001a\u0011fcV\fGN\u0003\u0011!A\u0001bWM\\4uQ\u0002\"x\u000e\t;iK\u0002Jg\u000e];uA\u0005\u0014(/Y=/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0015!!.\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q-dGnX:lKR\u001c\u0007nX1hO~3Gn\\1uQ\r|G.\u000b\u0017!a9*\u0014\u0006\t !c\u00012%kT'!-\u0006cU+R*!Q\r\u000b5\u000b\u0016\u00152]A\u0002\u0013i\u0015\u0011G\u0019>\u000bE+K\u0015-A!\u001a\u0015i\u0015+)e9\u0002\u0004%Q*!\r2{\u0015\tV\u0015*Y\u0001B3)Q*UQMr\u0003\u0007I!TA\u0019cu*\u0011+*S1\u0002\u0003fQ!T)\"\"d\u0006\r\u0011B'\u00022EjT!US%b\u0003\u0005K\"B'RCSG\f\u0019!\u0003N\u0003c\tT(B)&J\u0003\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!\u0003\u00159'o\\;qC\t\tY)\u0001\u0006nSN\u001cwLZ;oGN\fQa]5oG\u0016\f#!!%\u0002\u000bQr\u0013G\f\u0019\u00023-cGnU6fi\u000eDw)\u001a;Rk\u0006tG/\u001b7f\r2|\u0017\r\u001e\t\u0003YY\u0019RAFAM\u0003K\u0003r!a'\u0002\"\u000e\u001b5*\u0004\u0002\u0002\u001e*\u0019\u0011qT\u0019\u0002\u000fI,h\u000e^5nK&!\u00111UAO\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**!\u00111VA\u001a\u0003\tIw.C\u0002@\u0003S#\"!!&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b-\u000bI,a/\t\u000b\u0005K\u0002\u0019A\"\t\u000b\u001dK\u0002\u0019A\"\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011YAg!\u0015\u0001\u00141YAd\u0013\r\t)-\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bA\nImQ\"\n\u0007\u0005-\u0017G\u0001\u0004UkBdWM\r\u0005\t\u0003\u001fT\u0012\u0011!a\u0001\u0017\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005U\u0007\u0003BA\u0017\u0003/LA!!7\u00020\t1qJ\u00196fGR\u0004")
public class KllSketchGetQuantileFloat
extends KllSketchGetQuantileBase
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(KllSketchGetQuantileFloat x$0) {
        return KllSketchGetQuantileFloat$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, KllSketchGetQuantileFloat> tupled() {
        return KllSketchGetQuantileFloat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, KllSketchGetQuantileFloat>> curried() {
        return KllSketchGetQuantileFloat$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public String prettyName() {
        return "kll_sketch_get_quantile_float";
    }

    @Override
    public DataType outputDataType() {
        return FloatType$.MODULE$;
    }

    @Override
    public Object kllSketchGetQuantile(Memory memory, double rank) {
        return this.withQuantileErrorHandling(rank, (JFunction0.mcF.sp & Serializable)() -> KllFloatsSketch.wrap((Memory)memory).getQuantile(rank));
    }

    @Override
    public Object[] kllSketchGetQuantiles(Memory memory, double[] ranks) {
        return (Object[])this.withQuantileErrorHandling(ranks.length > 0 ? ranks[0] : 0.0, (Function0 & Serializable)() -> (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.floatArrayOps(KllFloatsSketch.wrap((Memory)memory).getQuantiles(ranks)), (Function1 & Serializable)x$2 -> KllSketchGetQuantileFloat.$anonfun$kllSketchGetQuantiles$4(BoxesRunTime.unboxToFloat((Object)x$2)), ClassTag$.MODULE$.Any()));
    }

    public KllSketchGetQuantileFloat copy(Expression left, Expression right) {
        return new KllSketchGetQuantileFloat(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "KllSketchGetQuantileFloat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllSketchGetQuantileFloat;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllSketchGetQuantileFloat)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllSketchGetQuantileFloat kllSketchGetQuantileFloat = (KllSketchGetQuantileFloat)x$1;
        Expression expression = this.left();
        Expression expression2 = kllSketchGetQuantileFloat.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = kllSketchGetQuantileFloat.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!kllSketchGetQuantileFloat.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$kllSketchGetQuantiles$4(float x$2) {
        return BoxesRunTime.boxToFloat((float)x$2);
    }

    public KllSketchGetQuantileFloat(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

