/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.logging.log4j.core.util.OptionConverter;

public class NoDeleteRollingFileAppender
extends FileAppender {
    protected long maxFileSize = 0xA00000L;
    private long nextRollover = 0L;

    public NoDeleteRollingFileAppender() {
    }

    public NoDeleteRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public NoDeleteRollingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void rollOver() {
        if (this.qw != null) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug((String)("rolling over count=" + size));
            this.nextRollover = size + this.maxFileSize;
        }
        this.closeFile();
        int p = this.fileName.lastIndexOf(".");
        String file = p > 0 ? this.fileName.substring(0, p) : this.fileName;
        try {
            this.setFile(file, false, this.bufferedIO, this.bufferSize);
            this.nextRollover = 0L;
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error((String)("setFile(" + file + ", false) call failed."), (Throwable)e);
        }
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        String newFileName = NoDeleteRollingFileAppender.getLogFileName(fileName);
        super.setFile(newFileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File f = new File(newFileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (this.fileName != null && this.qw != null && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOver();
        }
    }

    private static String getLogFileName(String oldFileName) {
        return oldFileName + "." + Long.toString(System.currentTimeMillis());
    }
}

