/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBasePad;

@Description(name="rpad", value="_FUNC_(str, len, pad) - Returns str, right-padded with pad to a length of len", extended="If str is longer than len, the return value is shortened to len characters.\nIn case of empty pad string, the return value is null.\nExample:\n  > SELECT _FUNC_('hi', 5, '??') FROM src LIMIT 1;\n  'hi???'\n  > SELECT _FUNC_('hi', 1, '??') FROM src LIMIT 1;\n  'h'\n  > SELECT _FUNC_('hi', 5, '') FROM src LIMIT 1;\n  null")
public class GenericUDFRpad
extends GenericUDFBasePad {
    public GenericUDFRpad() {
        super("rpad");
    }

    @Override
    protected void performOp(StringBuilder builder, int len, String str, String pad) {
        int pos;
        builder.append(str, 0, pos);
        for (pos = str.length(); pos < len; pos += pad.length()) {
            builder.append(pad);
        }
        builder.setLength(len);
    }
}

