/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.ToAvro$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(child[, jsonFormatSchema]) - Converts a Catalyst binary input value into its\n      corresponding Avro format result.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(s, '{\"type\": \"record\", \"name\": \"struct\", \"fields\": [{ \"name\": \"u\", \"type\": [\"int\",\"string\"] }]}') IS NULL FROM (SELECT NULL AS s);\n       [true]\n      > SELECT _FUNC_(s) IS NULL FROM (SELECT NULL AS s);\n       [true]\n  ", group="avro_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u0010 \u00012B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005N\u0001\tE\t\u0015!\u0003I\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015q\u0005\u0001\"\u0001T\u0011\u0015)\u0006\u0001\"\u0011H\u0011\u00151\u0006\u0001\"\u0011H\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015i\u0006\u0001\"\u0011_\u0011!)\u0007\u0001#b\u0001\n\u0003:\u0005\"\u00024\u0001\t\u0003:\u0007b\u00029\u0001\u0003\u0003%\t!\u001d\u0005\bi\u0002\t\n\u0011\"\u0001v\u0011!\t\t\u0001AI\u0001\n\u0003)\b\"CA\u0002\u0001\u0005\u0005I\u0011IA\u0003\u0011%\t)\u0002AA\u0001\n\u0003\t9\u0002C\u0005\u0002 \u0001\t\t\u0011\"\u0001\u0002\"!I\u0011Q\u0006\u0001\u0002\u0002\u0013\u0005\u0013q\u0006\u0005\n\u0003{\u0001\u0011\u0011!C\u0001\u0003\u007fA\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\t\u0013\u0005=\u0003!!A\u0005B\u0005Es!CA;?\u0005\u0005\t\u0012AA<\r!qr$!A\t\u0002\u0005e\u0004B\u0002(\u0019\t\u0003\t\t\nC\u0005\u0002\u0014b\t\t\u0011\"\u0012\u0002\u0016\"I\u0011q\u0013\r\u0002\u0002\u0013\u0005\u0015\u0011\u0014\u0005\n\u0003?C\u0012\u0011!CA\u0003CC\u0011\"a-\u0019\u0003\u0003%I!!.\u0003\rQ{\u0017I\u001e:p\u0015\t\u0001\u0013%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0012$\u0003!\u0019\u0017\r^1msN$(B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO\u000e\u00011#\u0002\u0001.cQR\u0004C\u0001\u00180\u001b\u0005y\u0012B\u0001\u0019 \u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0004Qe>$Wo\u0019;\u0011\u0005m\u001aeB\u0001\u001fB\u001d\ti\u0004)D\u0001?\u0015\ty4&\u0001\u0004=e>|GOP\u0005\u0002o%\u0011!IN\u0001\ba\u0006\u001c7.Y4f\u0013\t!UI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Cm\u0005)1\r[5mIV\t\u0001\n\u0005\u0002/\u0013&\u0011!j\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\tkg>tgi\u001c:nCR\u001c6\r[3nC\u0006\t\"n]8o\r>\u0014X.\u0019;TG\",W.\u0019\u0011\u0002\rqJg.\u001b;?)\r\u0001\u0016K\u0015\t\u0003]\u0001AQAR\u0003A\u0002!CQ\u0001T\u0003A\u0002!#\"\u0001\u0015+\t\u000b\u00193\u0001\u0019\u0001%\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2\u0001S-\\\u0011\u0015Q\u0016\u00021\u0001I\u0003\u001dqWm\u001e'fMRDQ\u0001X\u0005A\u0002!\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!-I\u0001\tC:\fG._:jg&\u0011A-\u0019\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002QB\u0011\u0011.\u001c\b\u0003U.\u0004\"!\u0010\u001c\n\u000514\u0014A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\u001c\u001c\u0002\t\r|\u0007/\u001f\u000b\u0004!J\u001c\bb\u0002$\u000e!\u0003\u0005\r\u0001\u0013\u0005\b\u00196\u0001\n\u00111\u0001I\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u001e\u0016\u0003\u0011^\\\u0013\u0001\u001f\t\u0003szl\u0011A\u001f\u0006\u0003wr\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005u4\u0014AC1o]>$\u0018\r^5p]&\u0011qP\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0012\u0005!!.\u0019<b\u0013\rq\u00171B\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00033\u00012!NA\u000e\u0013\r\tiB\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003G\tI\u0003E\u00026\u0003KI1!a\n7\u0005\r\te.\u001f\u0005\n\u0003W\u0011\u0012\u0011!a\u0001\u00033\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0019!\u0019\t\u0019$!\u000f\u0002$5\u0011\u0011Q\u0007\u0006\u0004\u0003o1\u0014AC2pY2,7\r^5p]&!\u00111HA\u001b\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0005\u0013q\t\t\u0004k\u0005\r\u0013bAA#m\t9!i\\8mK\u0006t\u0007\"CA\u0016)\u0005\u0005\t\u0019AA\u0012\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u001d\u0011Q\n\u0005\n\u0003W)\u0012\u0011!a\u0001\u00033\ta!Z9vC2\u001cH\u0003BA!\u0003'B\u0011\"a\u000b\u0017\u0003\u0003\u0005\r!a\t)'\u0001\t9&!\u0018\u0002`\u0005\r\u0014QMA5\u0003W\ny'!\u001d\u0011\u00079\nI&C\u0002\u0002\\}\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002b\u0005\t9A\u0003\u0011!A\u0001zf)\u0016(D?\"\u001a\u0007.\u001b7e72\u0002#n]8o\r>\u0014X.\u0019;TG\",W.Y/*A5\u00023i\u001c8wKJ$8\u000fI1!\u0007\u0006$\u0018\r\\=ti\u0002\u0012\u0017N\\1ss\u0002Jg\u000e];uAY\fG.^3!S:$x\u000eI5ug*\u0001\u0003\u0005\t\u0011!A\r|'O]3ta>tG-\u001b8hA\u00053(o\u001c\u0011g_Jl\u0017\r\u001e\u0011sKN,H\u000e\u001e\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003O\n!\u0011\u0001\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)g2\u0002se\u001f\u0012usB,'E\u000f\u0011#e\u0016\u001cwN\u001d3#Y\u0001\u0012c.Y7fEi\u0002#e\u001d;sk\u000e$(\u0005\f\u0011#M&,G\u000eZ:#u\u0001Z6\u0010\t\u0012oC6,'E\u000f\u0011#k\nb\u0003E\t;za\u0016\u0014#\bI.#S:$(\u0005\f\u0012tiJLgn\u001a\u0012^AulVpJ\u0015!\u0013N\u0003c*\u0016'MA\u0019\u0013v*\u0014\u0011)'\u0016cUi\u0011+!\u001dVcE\nI!TAML3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.ueV,WL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015tS\u0001J5\u000b\t(V\u00192\u0003cIU(NA!\u001aV\tT#D)\u0002rU\u000b\u0014'!\u0003N\u00033/K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7R\u0014X/Z/\u000bA\u0001\nQa\u001a:pkB\f#!!\u001c\u0002\u0015\u00054(o\\0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002t\u0005)AG\f\u0019/a\u00051Ak\\!we>\u0004\"A\f\r\u0014\u000ba\tY(a\"\u0011\u000f\u0005u\u00141\u0011%I!6\u0011\u0011q\u0010\u0006\u0004\u0003\u00033\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u000b\u000byHA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by!\u0001\u0002j_&\u0019A)a#\u0015\u0005\u0005]\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0011!B1qa2LH#\u0002)\u0002\u001c\u0006u\u0005\"\u0002$\u001c\u0001\u0004A\u0005\"\u0002'\u001c\u0001\u0004A\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003G\u000by\u000bE\u00036\u0003K\u000bI+C\u0002\u0002(Z\u0012aa\u00149uS>t\u0007#B\u001b\u0002,\"C\u0015bAAWm\t1A+\u001e9mKJB\u0001\"!-\u001d\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA\\!\u0011\tI!!/\n\t\u0005m\u00161\u0002\u0002\u0007\u001f\nTWm\u0019;")
public class ToAvro
extends BinaryExpression
implements RuntimeReplaceable,
Serializable {
    private Expression replacement;
    private final Expression child;
    private final Expression jsonFormatSchema;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ToAvro x$0) {
        return ToAvro$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ToAvro> tupled() {
        return ToAvro$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ToAvro>> curried() {
        return ToAvro$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ToAvro toAvro = this;
        synchronized (toAvro) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression child() {
        return this.child;
    }

    public Expression jsonFormatSchema() {
        return this.jsonFormatSchema;
    }

    @Override
    public Expression left() {
        return this.child();
    }

    @Override
    public Expression right() {
        return this.jsonFormatSchema();
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.jsonFormatSchema().dataType();
        if (dataType instanceof StringType && this.jsonFormatSchema().foldable()) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        if (dataType instanceof NullType) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.TypeCheckFailure("The second argument of the TO_AVRO SQL function must be a constant string containing the JSON representation of the schema to use for converting the value to AVRO format");
    }

    private Expression replacement$lzycompute() {
        ToAvro toAvro = this;
        synchronized (toAvro) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                None$ none$;
                Object object = this.jsonFormatSchema().eval(this.jsonFormatSchema().eval$default$1());
                if (object == null) {
                    none$ = None$.MODULE$;
                } else if (object instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)object;
                    none$ = new Some((Object)uTF8String.toString());
                } else {
                    throw new MatchError(object);
                }
                None$ schemaValue = none$;
                Constructor constructor = ToAvro.liftedTree2$1();
                Object expr = constructor.newInstance(this.child(), schemaValue);
                this.replacement = (Expression)expr;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "to_avro");
    }

    public ToAvro copy(Expression child, Expression jsonFormatSchema) {
        return new ToAvro(child, jsonFormatSchema);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.jsonFormatSchema();
    }

    @Override
    public String productPrefix() {
        return "ToAvro";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.jsonFormatSchema();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToAvro;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "jsonFormatSchema";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToAvro)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToAvro toAvro = (ToAvro)x$1;
        Expression expression = this.child();
        Expression expression2 = toAvro.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.jsonFormatSchema();
        Expression expression4 = toAvro.jsonFormatSchema();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!toAvro.canEqual(this)) return false;
        return true;
    }

    private static final /* synthetic */ Constructor liftedTree2$1() {
        Constructor constructor;
        try {
            constructor = (Constructor)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.classForName("org.apache.spark.sql.avro.CatalystDataToAvro", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructors()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw QueryCompilationErrors$.MODULE$.avroNotLoadedSqlFunctionsUnusable("TO_AVRO");
        }
        return constructor;
    }

    public ToAvro(Expression child, Expression jsonFormatSchema) {
        this.child = child;
        this.jsonFormatSchema = jsonFormatSchema;
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public ToAvro(Expression child) {
        this(child, Literal$.MODULE$.apply(null));
    }
}

