/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0005ed!B\r\u001b\u0003\u0003)\u0003\"\u0002\u0017\u0001\t\u0003i\u0003\"\u0002\u0019\u0001\r\u0003\t\u0004\"\u0002!\u0001\r\u0003\t\u0005\"\u0002!\u0001\t\u0003I\u0005\"\u0002'\u0001\r\u0003i\u0005\"\u0002'\u0001\t\u0003\u0011\u0006\"\u0002'\u0001\t\u0003A\u0006\"\u0002'\u0001\t\u0003q\u0006\"\u00023\u0001\r\u0003)\u0007\"\u00023\u0001\t\u0003i\u0007\"\u0002<\u0001\r\u00039\bB\u0002<\u0001\r\u0003\ty\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t\u0019\u0004\u0001D\u0001\u0003kAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005=\u0003A\"\u0005\u0002R!9\u0011Q\f\u0001\u0005\u0012\u0005}\u0003bBA1\u0001\u0011E\u0011q\f\u0005\t\u0003G\u0002A\u0011\u0001\u000f\u0002f\t\u0001B)\u0019;b'R\u0014X-Y7SK\u0006$WM\u001d\u0006\u00037q\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u00025\u00051am\u001c:nCR$\"AM\u001a\u000e\u0003\u0001AQ\u0001\u000e\u0002A\u0002U\naa]8ve\u000e,\u0007C\u0001\u001c>\u001d\t94\b\u0005\u00029Q5\t\u0011H\u0003\u0002;I\u00051AH]8pizJ!\u0001\u0010\u0015\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003y!\naa]2iK6\fGC\u0001\u001aC\u0011\u0015\u00015\u00011\u0001D!\t!u)D\u0001F\u0015\t1E$A\u0003usB,7/\u0003\u0002I\u000b\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0015\u0005IR\u0005\"B&\u0005\u0001\u0004)\u0014\u0001D:dQ\u0016l\u0017m\u0015;sS:<\u0017AB8qi&|g\u000eF\u00023\u001dBCQaT\u0003A\u0002U\n1a[3z\u0011\u0015\tV\u00011\u00016\u0003\u00151\u0018\r\\;f)\r\u00114\u000b\u0016\u0005\u0006\u001f\u001a\u0001\r!\u000e\u0005\u0006#\u001a\u0001\r!\u0016\t\u0003OYK!a\u0016\u0015\u0003\u000f\t{w\u000e\\3b]R\u0019!'\u0017.\t\u000b=;\u0001\u0019A\u001b\t\u000bE;\u0001\u0019A.\u0011\u0005\u001db\u0016BA/)\u0005\u0011auN\\4\u0015\u0007Iz\u0006\rC\u0003P\u0011\u0001\u0007Q\u0007C\u0003R\u0011\u0001\u0007\u0011\r\u0005\u0002(E&\u00111\r\u000b\u0002\u0007\t>,(\r\\3\u0002\u000f=\u0004H/[8ogR\u0011!G\u001a\u0005\u0006I&\u0001\ra\u001a\t\u0005Q.,T'D\u0001j\u0015\tQ\u0007&\u0001\u0006d_2dWm\u0019;j_:L!\u0001\\5\u0003\u00075\u000b\u0007\u000f\u0006\u00023]\")AM\u0003a\u0001_B!\u0001/^\u001b6\u001b\u0005\t(B\u0001:t\u0003\u0011)H/\u001b7\u000b\u0003Q\fAA[1wC&\u0011A.]\u0001\u0005Y>\fG\rF\u0001y!\rI\u0018\u0011\u0002\b\u0004u\u0006\u0015abA>\u0002\u00049\u0019A0!\u0001\u000f\u0005u|hB\u0001\u001d\u007f\u0013\u0005\u0019\u0013BA\u0011#\u0013\ty\u0002%\u0003\u0002\u001e=%\u0019\u0011q\u0001\u000f\u0002\u000fA\f7m[1hK&!\u00111BA\u0007\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002\bq!2\u0001_A\t\u0011\u0019\t\u0019\u0002\u0004a\u0001k\u0005!\u0001/\u0019;i\u0003\u0011Q7o\u001c8\u0015\u0007a\fI\u0002\u0003\u0004\u0002\u00145\u0001\r!N\u0001\u0004GN4Hc\u0001=\u0002 !1\u00111\u0003\bA\u0002U\n1\u0001_7m)\rA\u0018Q\u0005\u0005\u0007\u0003'y\u0001\u0019A\u001b\u0002\u0007=\u00148\rF\u0002y\u0003WAa!a\u0005\u0011\u0001\u0004)\u0014a\u00029beF,X\r\u001e\u000b\u0004q\u0006E\u0002BBA\n#\u0001\u0007Q'A\u0003uC\ndW\rF\u0002y\u0003oAa!!\u000f\u0013\u0001\u0004)\u0014!\u0003;bE2,g*Y7f\u0003\u0011!X\r\u001f;\u0015\u0007a\fy\u0004\u0003\u0004\u0002\u0014M\u0001\r!N\u0001\ti\u0016DHOR5mKR!\u0011QIA'!\u0015\t9%!\u00136\u001b\u0005a\u0012bAA&9\t9A)\u0019;bg\u0016$\bBBA\n)\u0001\u0007Q'A\fbgN,'\u000f\u001e(p'B,7-\u001b4jK\u0012\u001c6\r[3nCR!\u00111KA-!\r9\u0013QK\u0005\u0004\u0003/B#\u0001B+oSRDa!a\u0017\u0016\u0001\u0004)\u0014!C8qKJ\fG/[8o\u0003I1\u0018\r\\5eCR,'j]8o'\u000eDW-\\1\u0015\u0005\u0005M\u0013!\u0005<bY&$\u0017\r^3Y[2\u001c6\r[3nC\u0006\u0011b/\u00197jI\u0006$XmU8ve\u000e,g*Y7f)\u0011\t\u0019&a\u001a\t\r\u0005%\u0004\u00041\u00016\u0003)\u0019x.\u001e:dK:\u000bW.\u001a\u0015\u0004\u0001\u00055\u0004\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005Md$\u0001\u0006b]:|G/\u0019;j_:LA!a\u001e\u0002r\tAQI^8mm&tw\r")
public abstract class DataStreamReader {
    public abstract DataStreamReader format(String var1);

    public abstract DataStreamReader schema(StructType var1);

    public DataStreamReader schema(String schemaString) {
        return this.schema(StructType$.MODULE$.fromDDL(schemaString));
    }

    public abstract DataStreamReader option(String var1, String var2);

    public DataStreamReader option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataStreamReader option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataStreamReader option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public abstract DataStreamReader options(Map<String, String> var1);

    public DataStreamReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(options).asScala());
        return this;
    }

    public abstract Dataset<Row> load();

    public abstract Dataset<Row> load(String var1);

    public Dataset<Row> json(String path) {
        this.validateJsonSchema();
        return this.format("json").load(path);
    }

    public Dataset<Row> csv(String path) {
        return this.format("csv").load(path);
    }

    public Dataset<Row> xml(String path) {
        this.validateXmlSchema();
        return this.format("xml").load(path);
    }

    public Dataset<Row> orc(String path) {
        return this.format("orc").load(path);
    }

    public Dataset<Row> parquet(String path) {
        return this.format("parquet").load(path);
    }

    public abstract Dataset<Row> table(String var1);

    public Dataset<Row> text(String path) {
        return this.format("text").load(path);
    }

    public Dataset<String> textFile(String path) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(path).select("value", (Seq<String>)Nil$.MODULE$).as(Encoders$.MODULE$.STRING());
    }

    public abstract void assertNoSpecifiedSchema(String var1);

    public void validateJsonSchema() {
    }

    public void validateXmlSchema() {
    }

    public void validateSourceName(String sourceName) {
        Predef$.MODULE$.require(sourceName != null, (Function0 & Serializable)() -> "Source name cannot be null");
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sourceName)), (Function0 & Serializable)() -> "Source name cannot be empty");
        Regex validNamePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[a-zA-Z0-9_]+$"));
        if (!validNamePattern.pattern().matcher(sourceName).matches()) {
            throw new AnalysisException("STREAMING_QUERY_EVOLUTION_ERROR.INVALID_SOURCE_NAME", (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceName"), (Object)sourceName)}))));
        }
    }
}

