/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.ee10.servlet;

import jakarta.servlet.http.PushBuilder;
import java.util.Objects;
import java.util.Set;
import org.sparkproject.jetty.ee10.servlet.ServletContextRequest;
import org.sparkproject.jetty.http.HttpFields;
import org.sparkproject.jetty.http.HttpMethod;
import org.sparkproject.jetty.http.HttpURI;
import org.sparkproject.jetty.http.MetaData;
import org.sparkproject.jetty.util.URIUtil;

class PushBuilderImpl
implements PushBuilder {
    private final ServletContextRequest _request;
    private final HttpFields.Mutable _headers;
    private String _method;
    private String _query;
    private String _sessionId;
    private String _path;

    public PushBuilderImpl(ServletContextRequest request, HttpFields.Mutable headers, String sessionId) {
        this._request = request;
        this._headers = headers;
        this._method = request.getMethod();
        this._query = request.getHttpURI().getQuery();
        this._sessionId = sessionId;
    }

    public PushBuilder method(String method) {
        HttpMethod httpMethod = HttpMethod.fromString(Objects.requireNonNull(method));
        if (httpMethod == null || !httpMethod.isSafe() || httpMethod == HttpMethod.OPTIONS || httpMethod == HttpMethod.TRACE) {
            throw new IllegalArgumentException("method not allowed for push: " + method);
        }
        this._method = httpMethod.asString();
        return this;
    }

    public PushBuilder queryString(String queryString) {
        this._query = queryString;
        return this;
    }

    public PushBuilder sessionId(String sessionId) {
        this._sessionId = sessionId;
        return this;
    }

    public PushBuilder setHeader(String name, String value) {
        this._headers.put(name, value);
        return this;
    }

    public PushBuilder addHeader(String name, String value) {
        this._headers.add(name, value);
        return this;
    }

    public PushBuilder removeHeader(String name) {
        this._headers.remove(name);
        return this;
    }

    public PushBuilder path(String path) {
        this._path = path;
        return this;
    }

    public void push() {
        String pushPath = this.getPath();
        if (pushPath == null || pushPath.isBlank()) {
            throw new IllegalStateException("invalid push path: " + pushPath);
        }
        String query = this.getQueryString();
        Object pushQuery = query;
        int q = pushPath.indexOf(63);
        if (q > 0) {
            pushQuery = pushPath.substring(q + 1);
            if (query != null) {
                pushQuery = (String)pushQuery + "&" + query;
            }
            pushPath = pushPath.substring(0, q);
        }
        if (!pushPath.startsWith("/")) {
            pushPath = URIUtil.addPaths(this._request.getServletContext().getContextPath(), pushPath);
        }
        String pushParam = null;
        if (this._sessionId != null && this._request.getServletApiRequest().isRequestedSessionIdFromURL()) {
            pushParam = "jsessionid=" + this._sessionId;
        }
        HttpURI.Mutable pushURI = HttpURI.build(this._request.getHttpURI(), pushPath, pushParam, (String)pushQuery).normalize();
        MetaData.Request push = new MetaData.Request(this._request.getBeginNanoTime(), this._method, pushURI, this._request.getConnectionMetaData().getHttpVersion(), this._headers);
        this._request.push(push);
        this._path = null;
    }

    public String getMethod() {
        return this._method;
    }

    public String getQueryString() {
        return this._query;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public Set<String> getHeaderNames() {
        return this._headers.getFieldNamesCollection();
    }

    public String getHeader(String name) {
        return this._headers.get(name);
    }

    public String getPath() {
        return this._path;
    }
}

