/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.sparkproject.jetty.http.HttpFields;
import org.sparkproject.jetty.io.EndPoint;
import org.sparkproject.jetty.server.HttpConfiguration;
import org.sparkproject.jetty.server.ProxyConnectionFactory;
import org.sparkproject.jetty.server.Request;

public class ProxyCustomizer
implements HttpConfiguration.Customizer {
    public static final String REMOTE_ADDRESS_ATTRIBUTE_NAME = "org.sparkproject.jetty.proxy.remote.address";
    public static final String REMOTE_PORT_ATTRIBUTE_NAME = "org.sparkproject.jetty.proxy.remote.port";
    public static final String LOCAL_ADDRESS_ATTRIBUTE_NAME = "org.sparkproject.jetty.proxy.local.address";
    public static final String LOCAL_PORT_ATTRIBUTE_NAME = "org.sparkproject.jetty.proxy.local.port";

    @Override
    public Request customize(Request request, HttpFields.Mutable responseHeaders) {
        EndPoint endPoint = request.getConnectionMetaData().getConnection().getEndPoint();
        if (endPoint instanceof ProxyConnectionFactory.ProxyEndPoint) {
            EndPoint underlyingEndpoint = ((ProxyConnectionFactory.ProxyEndPoint)endPoint).unwrap();
            request = new ProxyRequest(request, underlyingEndpoint.getLocalSocketAddress(), underlyingEndpoint.getRemoteSocketAddress());
        }
        return request;
    }

    private static class ProxyRequest
    extends Request.Wrapper {
        private final String _remoteAddress;
        private final String _localAddress;
        private final int _remotePort;
        private final int _localPort;

        private ProxyRequest(Request request, SocketAddress local, SocketAddress remote) {
            super(request);
            InetSocketAddress inetLocal = local instanceof InetSocketAddress ? (InetSocketAddress)local : null;
            InetSocketAddress inetRemote = remote instanceof InetSocketAddress ? (InetSocketAddress)remote : null;
            this._localAddress = inetLocal == null ? null : inetLocal.getAddress().getHostAddress();
            this._remoteAddress = inetRemote == null ? null : inetRemote.getAddress().getHostAddress();
            this._localPort = inetLocal == null ? 0 : inetLocal.getPort();
            this._remotePort = inetRemote == null ? 0 : inetRemote.getPort();
        }

        @Override
        public Object getAttribute(String name) {
            return switch (name) {
                case ProxyCustomizer.REMOTE_ADDRESS_ATTRIBUTE_NAME -> this._remoteAddress;
                case ProxyCustomizer.REMOTE_PORT_ATTRIBUTE_NAME -> this._remotePort;
                case ProxyCustomizer.LOCAL_ADDRESS_ATTRIBUTE_NAME -> this._localAddress;
                case ProxyCustomizer.LOCAL_PORT_ATTRIBUTE_NAME -> this._localPort;
                default -> super.getAttribute(name);
            };
        }

        @Override
        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(super.getAttributeNameSet());
            names.remove(ProxyCustomizer.REMOTE_ADDRESS_ATTRIBUTE_NAME);
            names.remove(ProxyCustomizer.LOCAL_ADDRESS_ATTRIBUTE_NAME);
            if (this._remoteAddress != null) {
                names.add(ProxyCustomizer.REMOTE_ADDRESS_ATTRIBUTE_NAME);
            }
            if (this._localAddress != null) {
                names.add(ProxyCustomizer.LOCAL_ADDRESS_ATTRIBUTE_NAME);
            }
            names.add(ProxyCustomizer.REMOTE_PORT_ATTRIBUTE_NAME);
            names.add(ProxyCustomizer.LOCAL_PORT_ATTRIBUTE_NAME);
            return names;
        }
    }
}

