/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.cpc.CpcConfidence;
import org.apache.datasketches.cpc.IconEstimator;
import org.apache.datasketches.cpc.PreambleUtil;
import org.apache.datasketches.cpc.RuntimeAsserts;
import org.apache.datasketches.memory.Memory;

public final class CpcWrapper {
    Memory mem;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is OK here")
    public CpcWrapper(Memory mem) {
        this.mem = mem;
        PreambleUtil.checkLoPreamble(mem);
        RuntimeAsserts.rtAssert(PreambleUtil.isCompressed(mem));
    }

    public CpcWrapper(byte[] byteArray) {
        this(Memory.wrap((byte[])byteArray));
    }

    public double getEstimate() {
        if (!PreambleUtil.hasHip(this.mem)) {
            return IconEstimator.getIconEstimate(PreambleUtil.getLgK(this.mem), PreambleUtil.getNumCoupons(this.mem));
        }
        return PreambleUtil.getHipAccum(this.mem);
    }

    public static Family getFamily() {
        return Family.CPC;
    }

    public int getLgK() {
        return PreambleUtil.getLgK(this.mem);
    }

    public double getLowerBound(int kappa) {
        if (!PreambleUtil.hasHip(this.mem)) {
            return CpcConfidence.getIconConfidenceLB(PreambleUtil.getLgK(this.mem), PreambleUtil.getNumCoupons(this.mem), kappa);
        }
        return CpcConfidence.getHipConfidenceLB(PreambleUtil.getLgK(this.mem), PreambleUtil.getNumCoupons(this.mem), PreambleUtil.getHipAccum(this.mem), kappa);
    }

    public double getUpperBound(int kappa) {
        if (!PreambleUtil.hasHip(this.mem)) {
            return CpcConfidence.getIconConfidenceUB(PreambleUtil.getLgK(this.mem), PreambleUtil.getNumCoupons(this.mem), kappa);
        }
        return CpcConfidence.getHipConfidenceUB(PreambleUtil.getLgK(this.mem), PreambleUtil.getNumCoupons(this.mem), PreambleUtil.getHipAccum(this.mem), kappa);
    }
}

