/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service;

import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.exception.ApiDetailException;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.service.SettingService;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.UserService;
import org.apache.streampark.flink.kubernetes.ingress.IngressController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceHelper {
    @Autowired
    private SettingService settingService;
    @Autowired
    private UserService userService;
    private String sqlClientJar = null;

    public User getLoginUser() {
        String token = (String)SecurityUtils.getSubject().getPrincipal();
        Long userId = JWTUtil.getUserId(token);
        return (User)this.userService.getById(userId);
    }

    public Long getUserId() {
        User user = this.getLoginUser();
        if (user != null) {
            return user.getUserId();
        }
        return null;
    }

    public String getSqlClientJar(FlinkEnv flinkEnv) {
        if (this.sqlClientJar == null) {
            File localClient = WebUtils.getAppClientDir();
            ApiAlertException.throwIfFalse(localClient.exists(), "[StreamPark] " + localClient + " no exists. please check.");
            String regex = String.format("streampark-flink-sqlclient_%s-.*\\.jar", flinkEnv.getScalaVersion());
            List jars = Arrays.stream((Object[])Objects.requireNonNull(localClient.list())).filter(x -> x.matches(regex)).collect(Collectors.toList());
            ApiAlertException.throwIfTrue(jars.isEmpty(), "[StreamPark] can't found streampark-flink-sqlclient jar in " + localClient);
            ApiAlertException.throwIfTrue(jars.size() > 1, "[StreamPark] found multiple streampark-flink-sqlclient jar in " + localClient);
            this.sqlClientJar = (String)jars.get(0);
        }
        return this.sqlClientJar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String rollViewLog(String path, int offset, int limit) {
        try {
            File file = new File(path);
            if (!file.exists()) return null;
            if (!file.isFile()) return null;
            try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
                String string = stream.skip(offset).limit(limit).collect(Collectors.joining("\r\n"));
                return string;
            }
        }
        catch (Exception e) {
            throw new ApiDetailException("roll view log error: " + e);
        }
    }

    public void configureIngress(String clusterId, String namespace) throws KubernetesClientException {
        String domainName = this.settingService.getIngressModeDefault();
        if (StringUtils.isNotBlank((CharSequence)domainName)) {
            IngressController.configureIngress((String)domainName, (String)clusterId, (String)namespace);
        }
    }
}

