/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AbstractNode;
import com.google.gxp.compiler.base.Node;

public class JavaAnnotation
extends AbstractNode {
    private final Element element;
    private final String with;

    public JavaAnnotation(SourcePosition sourcePosition, String displayName, Element element, String with) {
        super(sourcePosition, displayName);
        this.element = element;
        this.with = Preconditions.checkNotNull(with);
    }

    public JavaAnnotation(Node fromNode, Element element, String with) {
        this(fromNode.getSourcePosition(), fromNode.getDisplayName(), element, with);
    }

    public Element getElement() {
        return this.element;
    }

    public String getWith() {
        return this.with;
    }

    public JavaAnnotation withElement(Element newElement) {
        return Objects.equal((Object)this.element, (Object)newElement) ? this : new JavaAnnotation(this, newElement, this.getWith());
    }

    public boolean equals(Object that) {
        return this == that || that instanceof JavaAnnotation && this.equals((JavaAnnotation)that);
    }

    public boolean equals(JavaAnnotation that) {
        return this.equalsAbstractNode(that) && Objects.equal((Object)this.getElement(), (Object)that.getElement()) && Objects.equal(this.getWith(), that.getWith());
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.abstractNodeHashCode(), this.getElement(), this.getWith()});
    }

    public static enum Element {
        CLASS,
        CONSTRUCTOR,
        INSTANCE,
        INTERFACE,
        PARAM;

    }
}

