/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PermitUnindexedSearchRequestControl
extends Control {
    @NotNull
    public static final String PERMIT_UNINDEXED_SEARCH_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.55";
    private static final long serialVersionUID = 7192052212547454117L;

    public PermitUnindexedSearchRequestControl() {
        this(false);
    }

    public PermitUnindexedSearchRequestControl(boolean isCritical) {
        super(PERMIT_UNINDEXED_SEARCH_REQUEST_OID, isCritical);
    }

    public PermitUnindexedSearchRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PERMIT_UNINDEXED_SEARCH_REQUEST_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PERMIT_UNINDEXED_SEARCH_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", PERMIT_UNINDEXED_SEARCH_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_PERMIT_UNINDEXED_SEARCH_REQUEST.get()), new JSONField("criticality", this.isCritical()));
    }

    @NotNull
    public static PermitUnindexedSearchRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, false, false);
        return new PermitUnindexedSearchRequestControl(jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PermitUnindexedSearchRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

