/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

public enum DigestChoice {
    SHA1("SHA-1", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"),
    SHA256("SHA-256", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"),
    SHA384("SHA-384", "http://www.w3.org/2001/04/xmldsig-more#sha384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"),
    SHA512("SHA-512", "http://www.w3.org/2001/04/xmlenc#sha512", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");

    private final String otherName;
    private final String digestAlgorithm;
    private final String rsaAlgorithm;
    private final String ecdsaAlgorithm;

    private DigestChoice(String otherNameArg, String digestArg, String rsaArg, String ecdsaArg) {
        this.otherName = otherNameArg;
        this.digestAlgorithm = digestArg;
        this.rsaAlgorithm = rsaArg;
        this.ecdsaAlgorithm = ecdsaArg;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getRSAAlgorithm() {
        return this.rsaAlgorithm;
    }

    public String getECDSAAlgorithm() {
        return this.ecdsaAlgorithm;
    }

    public boolean hasName(String name) {
        if (name.equalsIgnoreCase(this.name())) {
            return true;
        }
        return name.equalsIgnoreCase(this.otherName);
    }

    public static DigestChoice find(String name) {
        for (DigestChoice choice : DigestChoice.values()) {
            if (!choice.hasName(name)) continue;
            return choice;
        }
        return null;
    }
}

