/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.UserPullResultHandler;
import org.apache.syncope.core.provisioning.api.rules.PullMatch;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultAnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultGroupPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultRealmPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultUserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.PullResultHandlerDispatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class PullJobDelegate
extends AbstractProvisioningJobDelegate<PullTask>
implements SyncopePullExecutor {
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected PlainSchemaDAO plainSchemaDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    @Autowired
    protected PlainAttrValidationManager validator;
    protected final Map<String, SyncToken> latestSyncTokens = Collections.synchronizedMap(new HashMap());
    protected ProvisioningProfile<PullTask, PullActions> profile;
    protected final Map<String, MutablePair<Integer, String>> handled = new HashMap<String, MutablePair<Integer, String>>();
    protected final Map<String, PullActions> perContextActions = new ConcurrentHashMap<String, PullActions>();
    protected Optional<ReconFilterBuilder> perContextReconFilterBuilder = Optional.empty();

    public void setLatestSyncToken(String objectClass, SyncToken latestSyncToken) {
        this.latestSyncTokens.put(objectClass, latestSyncToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportHandled(String objectClass, Name name) {
        Map<String, MutablePair<Integer, String>> map = this.handled;
        synchronized (map) {
            MutablePair pair = Optional.ofNullable(this.handled.get(objectClass)).orElseGet(() -> {
                MutablePair p = MutablePair.of((Object)0, null);
                this.handled.put(objectClass, (MutablePair<Integer, String>)p);
                return p;
            });
            pair.setLeft((Object)((Integer)pair.getLeft() + 1));
            pair.setRight((Object)name.getNameValue());
            if (!this.handled.isEmpty()) {
                StringBuilder builder = new StringBuilder("Processed:\n");
                this.handled.forEach((k, v) -> builder.append(' ').append(v.getLeft()).append('\t').append((String)k).append(" / latest: ").append((String)v.getRight()).append('\n'));
                this.setStatus(builder.toString());
            }
        }
    }

    public boolean wasInterruptRequested() {
        return this.interrupt;
    }

    public void setInterrupted() {
        this.interrupted = true;
    }

    protected void setGroupOwners(GroupPullResultHandler ghandler) {
        ghandler.getGroupOwnerMap().forEach((groupKey, ownerKey) -> {
            Group group = (Group)this.groupDAO.find(groupKey);
            if (group == null) {
                throw new NotFoundException("Group " + groupKey);
            }
            if (StringUtils.isBlank((CharSequence)ownerKey)) {
                group.setGroupOwner(null);
                group.setUserOwner(null);
            } else {
                Optional<PullMatch> match = this.inboundMatcher.match(this.anyTypeDAO.findUser(), (String)ownerKey, ((PullTask)this.profile.getTask()).getResource(), this.profile.getConnector());
                if (match.isPresent()) {
                    group.setUserOwner((User)match.get().getAny());
                } else {
                    this.inboundMatcher.match(this.anyTypeDAO.findGroup(), (String)ownerKey, ((PullTask)this.profile.getTask()).getResource(), this.profile.getConnector()).ifPresent(groupMatch -> group.setGroupOwner((Group)groupMatch.getAny()));
                }
            }
            this.groupDAO.save((Any)group);
        });
    }

    protected List<PullActions> getPullActions(List<? extends Implementation> impls) {
        ArrayList<PullActions> result = new ArrayList<PullActions>();
        impls.forEach(impl -> {
            try {
                result.add((PullActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (PullActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected ReconFilterBuilder getReconFilterBuilder(PullTask pullTask) throws ClassNotFoundException {
        return (ReconFilterBuilder)ImplementationManager.build((Implementation)pullTask.getReconFilterBuilder(), () -> this.perContextReconFilterBuilder.orElse(null), instance -> {
            this.perContextReconFilterBuilder = Optional.of(instance);
        });
    }

    protected RealmPullResultHandler buildRealmHandler() {
        return (RealmPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultRealmPullResultHandler.class, 1, false);
    }

    protected AnyObjectPullResultHandler buildAnyObjectHandler() {
        return (AnyObjectPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultAnyObjectPullResultHandler.class, 1, false);
    }

    protected UserPullResultHandler buildUserHandler() {
        return (UserPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultUserPullResultHandler.class, 1, false);
    }

    protected GroupPullResultHandler buildGroupHandler() {
        return (GroupPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultGroupPullResultHandler.class, 1, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected String doExecuteProvisioning(PullTask pullTask, Connector connector, boolean dryRun, String executor, JobExecutionContext context) throws JobExecutionException {
        PullJobDelegate.LOG.debug("Executing pull on {}", (Object)pullTask.getResource());
        this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pullTask);
        this.profile.getActions().addAll(this.getPullActions(pullTask.getActions()));
        this.profile.setDryRun(dryRun);
        this.profile.setConflictResolutionAction(Optional.ofNullable(pullTask.getResource().getPullPolicy()).map((Function<PullPolicy, ConflictResolutionAction>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getConflictResolutionAction(), (Lorg/apache/syncope/core/persistence/api/entity/policy/PullPolicy;)Lorg/apache/syncope/common/lib/types/ConflictResolutionAction;)()).orElse(ConflictResolutionAction.IGNORE));
        this.profile.setExecutor(executor);
        dispatcher = new PullResultHandlerDispatcher(this.profile, this);
        this.latestSyncTokens.clear();
        if (!this.profile.isDryRun()) {
            for (PullActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
        }
        this.setStatus("Initialization completed");
        if (pullTask.getResource().getOrgUnit() != null) {
            this.setStatus("Pulling " + pullTask.getResource().getOrgUnit().getObjectClass());
            orgUnit = pullTask.getResource().getOrgUnit();
            moreAttrsToGet = new HashSet<E>();
            this.profile.getActions().forEach((Consumer<PullActions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doExecuteProvisioning$9(java.util.Set org.apache.syncope.common.lib.to.OrgUnit org.apache.syncope.core.provisioning.api.pushpull.PullActions ), (Lorg/apache/syncope/core/provisioning/api/pushpull/PullActions;)V)((PullJobDelegate)this, moreAttrsToGet, (OrgUnit)orgUnit));
            options = MappingUtils.buildOperationOptions(MappingUtils.getPullItems(orgUnit.getItems().stream()), (String[])moreAttrsToGet.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doExecuteProvisioning$10(int ), (I)[Ljava/lang/String;)()));
            dispatcher.addHandlerSupplier(orgUnit.getObjectClass(), (Supplier<SyncopePullResultHandler>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecuteProvisioning$11(), ()Lorg/apache/syncope/core/provisioning/api/pushpull/SyncopePullResultHandler;)((PullJobDelegate)this));
            try {
                switch (1.$SwitchMap$org$apache$syncope$common$lib$types$PullMode[pullTask.getPullMode().ordinal()]) {
                    case 1: {
                        if (!dryRun) {
                            this.latestSyncTokens.put(orgUnit.getObjectClass(), ConnObjectUtils.toSyncToken(orgUnit.getSyncToken()));
                        }
                        connector.sync(new ObjectClass(orgUnit.getObjectClass()), ConnObjectUtils.toSyncToken(orgUnit.getSyncToken()), (SyncResultsHandler)dispatcher, options);
                        if (!dryRun) {
                            orgUnit.setSyncToken(ConnObjectUtils.toString(this.latestSyncTokens.get(orgUnit.getObjectClass())));
                            this.resourceDAO.save(pullTask.getResource());
                        }
                        break;
                    }
                    case 2: {
                        connector.filteredReconciliation(new ObjectClass(orgUnit.getObjectClass()), this.getReconFilterBuilder(pullTask), (SyncResultsHandler)dispatcher, options);
                        break;
                    }
                    default: {
                        connector.fullReconciliation(new ObjectClass(orgUnit.getObjectClass()), (SyncResultsHandler)dispatcher, options);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
        }
        provisionSorter = this.getProvisionSorter(pullTask);
        ghandler = this.buildGroupHandler();
lbl47:
        // 7 sources

        block20: for (Provision provision : pullTask.getResource().getProvisions().stream().filter((Predicate<Provision>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doExecuteProvisioning$12(org.apache.syncope.common.lib.to.Provision ), (Lorg/apache/syncope/common/lib/to/Provision;)Z)()).sorted((Comparator<Provision>)provisionSorter).collect(Collectors.toList())) {
            this.setStatus("Pulling " + provision.getObjectClass());
            anyType = this.anyTypeDAO.find(provision.getAnyType());
            dispatcher.addHandlerSupplier(provision.getObjectClass(), (Supplier<SyncopePullResultHandler>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecuteProvisioning$13(org.apache.syncope.core.persistence.api.entity.AnyType org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler ), ()Lorg/apache/syncope/core/provisioning/api/pushpull/SyncopePullResultHandler;)((PullJobDelegate)this, (AnyType)anyType, (GroupPullResultHandler)ghandler));
            setSyncTokens = false;
            try {
                moreAttrsToGet = new HashSet<E>();
                this.profile.getActions().forEach((Consumer<PullActions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doExecuteProvisioning$14(java.util.Set org.apache.syncope.common.lib.to.Provision org.apache.syncope.core.provisioning.api.pushpull.PullActions ), (Lorg/apache/syncope/core/provisioning/api/pushpull/PullActions;)V)((PullJobDelegate)this, moreAttrsToGet, (Provision)provision));
                mapItems = Stream.concat(MappingUtils.getPullItems(provision.getMapping().getItems().stream()), this.virSchemaDAO.find(pullTask.getResource().getKey(), anyType.getKey()).stream().map((Function<VirSchema, Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, asLinkingMappingItem(), (Lorg/apache/syncope/core/persistence/api/entity/VirSchema;)Lorg/apache/syncope/common/lib/to/Item;)()));
                options = MappingUtils.buildOperationOptions(mapItems, (String[])moreAttrsToGet.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doExecuteProvisioning$15(int ), (I)[Ljava/lang/String;)()));
                switch (1.$SwitchMap$org$apache$syncope$common$lib$types$PullMode[pullTask.getPullMode().ordinal()]) {
                    case 1: {
                        if (!dryRun) {
                            this.latestSyncTokens.put(provision.getObjectClass(), ConnObjectUtils.toSyncToken(provision.getSyncToken()));
                        }
                        connector.sync(new ObjectClass(provision.getObjectClass()), ConnObjectUtils.toSyncToken(provision.getSyncToken()), (SyncResultsHandler)dispatcher, options);
                        if (dryRun) continue block20;
                        setSyncTokens = true;
                        ** break;
                    }
                    case 2: {
                        connector.filteredReconciliation(new ObjectClass(provision.getObjectClass()), this.getReconFilterBuilder(pullTask), (SyncResultsHandler)dispatcher, options);
                        ** break;
                    }
                    default: {
                        connector.fullReconciliation(new ObjectClass(provision.getObjectClass()), (SyncResultsHandler)dispatcher, options);
                        continue block20;
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
            finally {
                if (!setSyncTokens) continue;
                this.latestSyncTokens.forEach((BiConsumer<String, SyncToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$doExecuteProvisioning$17(org.apache.syncope.core.persistence.api.entity.task.PullTask java.lang.String org.identityconnectors.framework.common.objects.SyncToken ), (Ljava/lang/String;Lorg/identityconnectors/framework/common/objects/SyncToken;)V)((PullTask)pullTask));
                this.resourceDAO.save(pullTask.getResource());
            }
        }
        dispatcher.shutdown();
        for (Provision provision : pullTask.getResource().getProvisions().stream().filter((Predicate<Provision>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doExecuteProvisioning$18(org.apache.syncope.common.lib.to.Provision ), (Lorg/apache/syncope/common/lib/to/Provision;)Z)()).sorted((Comparator<Provision>)provisionSorter).collect(Collectors.toList())) {
            try {
                anyUtils = this.anyUtilsFactory.getInstance(this.anyTypeDAO.find(provision.getAnyType()).getKind());
                this.profile.getResults().stream().filter((Predicate<ProvisioningReport>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doExecuteProvisioning$19(org.apache.syncope.common.lib.to.Provision org.apache.syncope.common.lib.to.ProvisioningReport ), (Lorg/apache/syncope/common/lib/to/ProvisioningReport;)Z)((Provision)provision)).forEach((Consumer<ProvisioningReport>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doExecuteProvisioning$20(org.apache.syncope.core.persistence.api.entity.AnyUtils org.apache.syncope.common.lib.to.Provision org.apache.syncope.common.lib.to.ProvisioningReport ), (Lorg/apache/syncope/common/lib/to/ProvisioningReport;)V)((PullJobDelegate)this, (AnyUtils)anyUtils, (Provision)provision));
            }
            catch (Throwable t) {
                PullJobDelegate.LOG.error("While setting UID on create", t);
            }
        }
        try {
            this.setGroupOwners(ghandler);
        }
        catch (Exception e) {
            PullJobDelegate.LOG.error("While setting group owners", (Throwable)e);
        }
        if (!this.profile.isDryRun()) {
            for (PullActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
        }
        this.setStatus("Pull done");
        result = this.createReport(this.profile.getResults(), pullTask.getResource(), dryRun);
        PullJobDelegate.LOG.debug("Pull result: {}", (Object)result);
        return result;
    }

    private /* synthetic */ void lambda$doExecuteProvisioning$20(AnyUtils anyUtils, Provision provision, ProvisioningReport result) {
        anyUtils.addAttr(this.validator, result.getKey(), (PlainSchema)this.plainSchemaDAO.find(provision.getUidOnCreate()), result.getUidValue());
    }

    private static /* synthetic */ boolean lambda$doExecuteProvisioning$19(Provision provision, ProvisioningReport result) {
        return result.getUidValue() != null && result.getKey() != null && result.getOperation() == ResourceOperation.CREATE && result.getAnyType().equals(provision.getAnyType());
    }

    private static /* synthetic */ boolean lambda$doExecuteProvisioning$18(Provision provision) {
        return provision.getMapping() != null && provision.getUidOnCreate() != null;
    }

    private static /* synthetic */ void lambda$doExecuteProvisioning$17(PullTask pullTask, String objectClass, SyncToken syncToken) {
        pullTask.getResource().getProvisionByObjectClass(objectClass).ifPresent(p -> p.setSyncToken(ConnObjectUtils.toString(syncToken)));
    }

    private static /* synthetic */ String[] lambda$doExecuteProvisioning$15(int x$0) {
        return new String[x$0];
    }

    private /* synthetic */ void lambda$doExecuteProvisioning$14(Set moreAttrsToGet, Provision provision, PullActions a) {
        moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, provision));
    }

    private /* synthetic */ SyncopePullResultHandler lambda$doExecuteProvisioning$13(AnyType anyType, GroupPullResultHandler ghandler) {
        GroupPullResultHandler handler;
        switch (anyType.getKind()) {
            case USER: {
                handler = this.buildUserHandler();
                break;
            }
            case GROUP: {
                handler = ghandler;
                break;
            }
            default: {
                handler = this.buildAnyObjectHandler();
            }
        }
        handler.setProfile(this.profile);
        return handler;
    }

    private static /* synthetic */ boolean lambda$doExecuteProvisioning$12(Provision provision) {
        return provision.getMapping() != null;
    }

    private /* synthetic */ SyncopePullResultHandler lambda$doExecuteProvisioning$11() {
        RealmPullResultHandler handler = this.buildRealmHandler();
        handler.setProfile(this.profile);
        return handler;
    }

    private static /* synthetic */ String[] lambda$doExecuteProvisioning$10(int x$0) {
        return new String[x$0];
    }

    private /* synthetic */ void lambda$doExecuteProvisioning$9(Set moreAttrsToGet, OrgUnit orgUnit, PullActions a) {
        moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, orgUnit));
    }
}

