/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.identityconnectors.common.security.GuardedString;

public abstract class AbstractValueDeserializer<T>
extends JsonDeserializer<T> {
    protected List<Object> doDeserialize(JsonNode value, JsonParser jp) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (JsonNode node : value) {
            if (node.isNull()) {
                values.add(null);
                continue;
            }
            if (node.isObject()) {
                values.add(((ObjectNode)node).traverse(jp.getCodec()).readValueAs(GuardedString.class));
                continue;
            }
            if (node.isBoolean()) {
                values.add(node.asBoolean());
                continue;
            }
            if (node.isDouble()) {
                values.add(node.asDouble());
                continue;
            }
            if (node.isLong()) {
                values.add(node.asLong());
                continue;
            }
            if (node.isInt()) {
                values.add(node.asInt());
                continue;
            }
            String text = node.asText();
            if (text.startsWith("<binary>") && text.endsWith("</binary>")) {
                values.add(Base64.getDecoder().decode(StringUtils.substringBetween((String)text, (String)"<binary>", (String)"</binary>")));
                continue;
            }
            values.add(text);
        }
        return values;
    }
}

