/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.filter.FilteredHeaderItem;
import org.apache.wicket.markup.head.internal.HeaderResponse;
import org.apache.wicket.markup.html.DecoratingHeaderResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.response.StringResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringHeaderResponse
extends DecoratingHeaderResponse {
    private static final Logger log = LoggerFactory.getLogger(FilteringHeaderResponse.class);
    public static final String DEFAULT_HEADER_FILTER_NAME = "wicket-default-header-filter";
    private static final MetaDataKey<FilteringHeaderResponse> RESPONSE_KEY = new MetaDataKey<FilteringHeaderResponse>(){
        private static final long serialVersionUID = 1L;
    };
    private final Map<String, List<HeaderItem>> responseFilterMap = new HashMap<String, List<HeaderItem>>();
    private Iterable<? extends IHeaderResponseFilter> filters;
    private final String headerFilterName;

    public FilteringHeaderResponse(IHeaderResponse response) {
        this(response, DEFAULT_HEADER_FILTER_NAME, Collections.emptyList());
    }

    public FilteringHeaderResponse(IHeaderResponse response, String headerFilterName, Iterable<? extends IHeaderResponseFilter> filters) {
        super(response);
        this.headerFilterName = headerFilterName;
        this.setFilters(filters);
        RequestCycle.get().setMetaData((MetaDataKey)RESPONSE_KEY, this);
    }

    protected void setFilters(Iterable<? extends IHeaderResponseFilter> filters) {
        this.filters = filters;
        if (filters == null) {
            return;
        }
        for (IHeaderResponseFilter iHeaderResponseFilter : filters) {
            this.responseFilterMap.put(iHeaderResponseFilter.getName(), new ArrayList());
        }
    }

    public static FilteringHeaderResponse get() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            throw new IllegalStateException("You can only get the FilteringHeaderResponse when there is a RequestCycle present");
        }
        FilteringHeaderResponse response = requestCycle.getMetaData(RESPONSE_KEY);
        if (response == null) {
            throw new IllegalStateException("No FilteringHeaderResponse is present in the request cycle.  This may mean that you have not decorated the header response with a FilteringHeaderResponse.  Simply calling the FilteringHeaderResponse constructor sets itself on the request cycle");
        }
        return response;
    }

    @Override
    public void render(HeaderItem item) {
        if (item instanceof FilteredHeaderItem) {
            String filterName = ((FilteredHeaderItem)item).getFilterName();
            if (!this.responseFilterMap.containsKey(filterName)) {
                this.responseFilterMap.put(filterName, new ArrayList());
            }
            this.render(item, filterName);
        } else {
            if (this.filters != null) {
                for (IHeaderResponseFilter iHeaderResponseFilter : this.filters) {
                    if (!iHeaderResponseFilter.accepts(item)) continue;
                    this.render(item, iHeaderResponseFilter.getName());
                    return;
                }
            }
            if (!this.responseFilterMap.containsKey(this.headerFilterName)) {
                this.responseFilterMap.put(this.headerFilterName, new ArrayList());
            }
            this.render(item, this.headerFilterName);
            log.debug("A HeaderItem '{}' was rendered to the filtering header response, but did not match any filters, so it put in the <head>.", (Object)item);
        }
    }

    @Override
    public void close() {
        CharSequence headerContent = this.getContent(this.headerFilterName);
        RequestCycle.get().getResponse().write(headerContent);
        super.close();
    }

    public final CharSequence getContent(String filterName) {
        if (filterName == null || !this.responseFilterMap.containsKey(filterName)) {
            return "";
        }
        List<HeaderItem> resp = this.responseFilterMap.get(filterName);
        final StringResponse strResponse = new StringResponse();
        IHeaderResponse headerRenderer = new HeaderResponse(){

            @Override
            protected Response getRealResponse() {
                return strResponse;
            }

            @Override
            public boolean wasRendered(Object object) {
                return FilteringHeaderResponse.this.getRealResponse().wasRendered(object);
            }

            @Override
            public void markRendered(Object object) {
                FilteringHeaderResponse.this.getRealResponse().markRendered(object);
            }
        };
        headerRenderer = this.decorate(headerRenderer);
        for (HeaderItem curItem : resp) {
            headerRenderer.render(curItem);
        }
        headerRenderer.close();
        return strResponse.getBuffer();
    }

    protected IHeaderResponse decorate(IHeaderResponse response) {
        return response;
    }

    private void render(HeaderItem item, String filterName) {
        if (!this.responseFilterMap.containsKey(filterName)) {
            throw new IllegalArgumentException("No filter named '" + filterName + "', known filter names are: " + String.valueOf(this.responseFilterMap.keySet()));
        }
        this.render(item, this.responseFilterMap.get(filterName));
    }

    protected void render(HeaderItem item, List<HeaderItem> filteredItems) {
        if (RequestCycle.get().find(IPartialPageRequestHandler.class).isPresent()) {
            this.getRealResponse().render(item);
            return;
        }
        filteredItems.add(item);
    }

    public static interface IHeaderResponseFilter
    extends Predicate<HeaderItem> {
        public String getName();

        public boolean accepts(HeaderItem var1);

        @Override
        default public boolean test(HeaderItem item) {
            return this.accepts(item);
        }
    }
}

