/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.IWebSocketConnectionFilter;
import org.apache.wicket.protocol.ws.api.IWebSocketSession;
import org.apache.wicket.protocol.ws.api.IWebSocketSessionConfigurer;
import org.apache.wicket.protocol.ws.api.ServletRequestCopy;
import org.apache.wicket.protocol.ws.api.WebSocketRequest;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.WebSocketResponse;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.api.registry.SimpleWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.concurrent.Executor;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketSettings {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketSettings.class);
    private static final MetaDataKey<WebSocketSettings> KEY = new MetaDataKey<WebSocketSettings>(){};
    private final AtomicReference<CharSequence> filterPrefix = new AtomicReference();
    private final AtomicReference<CharSequence> contextPath = new AtomicReference();
    private final AtomicReference<CharSequence> baseUrl = new AtomicReference();
    private final AtomicInteger port = new AtomicInteger();
    private final AtomicInteger securePort = new AtomicInteger();
    private Executor webSocketPushMessageExecutor = new WebSocketPushMessageExecutor();
    private Executor sendPayloadExecutor = new SameThreadExecutor();
    private IWebSocketConnectionRegistry connectionRegistry = new SimpleWebSocketConnectionRegistry();
    private IWebSocketConnectionFilter connectionFilter;
    private IWebSocketSessionConfigurer socketSessionConfigurer = new IWebSocketSessionConfigurer(){

        @Override
        public void configureSession(IWebSocketSession webSocketSession) {
        }
    };
    private Function<Integer, Boolean> notifyOnCloseEvent = code -> true;
    private boolean asynchronousPush = false;
    private long asynchronousPushTimeout = -1L;
    private Function<Throwable, Boolean> notifyOnErrorEvent = throwable -> true;

    public boolean shouldNotifyOnCloseEvent(int closeCode) {
        return this.notifyOnCloseEvent == null || this.notifyOnCloseEvent.apply(closeCode) != false;
    }

    public void setNotifyOnCloseEvent(Function<Integer, Boolean> notifyOnCloseEvent) {
        this.notifyOnCloseEvent = notifyOnCloseEvent;
    }

    public boolean shouldNotifyOnErrorEvent(Throwable throwable) {
        return this.notifyOnErrorEvent == null || this.notifyOnErrorEvent.apply(throwable) != false;
    }

    public void setNotifyOnErrorEvent(Function<Throwable, Boolean> notifyOnErrorEvent) {
        this.notifyOnErrorEvent = notifyOnErrorEvent;
    }

    public WebSocketSettings setWebSocketPushMessageExecutor(Executor executor) {
        Args.notNull((Object)executor, (String)"executor");
        this.webSocketPushMessageExecutor = executor;
        return this;
    }

    public Executor getWebSocketPushMessageExecutor() {
        return this.webSocketPushMessageExecutor;
    }

    public IWebSocketConnectionRegistry getConnectionRegistry() {
        return this.connectionRegistry;
    }

    public WebSocketSettings setConnectionRegistry(IWebSocketConnectionRegistry connectionRegistry) {
        Args.notNull((Object)connectionRegistry, (String)"connectionRegistry");
        this.connectionRegistry = connectionRegistry;
        return this;
    }

    public WebSocketSettings setSendPayloadExecutor(Executor sendPayloadExecutor) {
        Args.notNull((Object)sendPayloadExecutor, (String)"sendPayloadExecutor");
        this.sendPayloadExecutor = sendPayloadExecutor;
        return this;
    }

    public Executor getSendPayloadExecutor() {
        return this.sendPayloadExecutor;
    }

    public void setSocketSessionConfigurer(IWebSocketSessionConfigurer socketSessionConfigurer) {
        Args.notNull((Object)socketSessionConfigurer, (String)"socketSessionConfigurer");
        this.socketSessionConfigurer = socketSessionConfigurer;
    }

    public IWebSocketSessionConfigurer getSocketSessionConfigurer() {
        return this.socketSessionConfigurer;
    }

    public void setConnectionFilter(IWebSocketConnectionFilter connectionFilter) {
        this.connectionFilter = connectionFilter;
    }

    public IWebSocketConnectionFilter getConnectionFilter() {
        return this.connectionFilter;
    }

    public WebResponse newWebSocketResponse(IWebSocketConnection connection) {
        return this.newWebSocketResponse(connection, this.isAsynchronousPush(), this.getAsynchronousPushTimeout());
    }

    public WebResponse newWebSocketResponse(IWebSocketConnection connection, boolean asynchronousPush, long timeout) {
        return new WebSocketResponse(connection, asynchronousPush, timeout);
    }

    public WebSocketRequestHandler newWebSocketRequestHandler(Page page, IWebSocketConnection connection) {
        return new WebSocketRequestHandler((Component)page, connection);
    }

    public WebRequest newWebSocketRequest(HttpServletRequest request, String filterPath) {
        return new WebSocketRequest(new ServletRequestCopy(request), filterPath);
    }

    public void setFilterPrefix(CharSequence filterPrefix) {
        this.filterPrefix.set(filterPrefix);
    }

    public CharSequence getFilterPrefix() {
        if (this.filterPrefix.get() == null) {
            this.filterPrefix.compareAndSet(null, "");
        }
        return this.filterPrefix.get();
    }

    public void setContextPath(CharSequence contextPath) {
        this.contextPath.set(contextPath);
    }

    public CharSequence getContextPath() {
        this.contextPath.compareAndSet(null, RequestCycle.get().getRequest().getContextPath());
        return this.contextPath.get();
    }

    public void setBaseUrl(CharSequence baseUrl) {
        this.baseUrl.set(baseUrl);
    }

    public CharSequence getBaseUrl() {
        if (this.baseUrl.get() == null) {
            Url _baseUrl = RequestCycle.get().getUrlRenderer().getBaseUrl();
            return Strings.escapeMarkup((CharSequence)_baseUrl.toString());
        }
        return this.baseUrl.get();
    }

    public void setPort(int wsPort) {
        this.port.set(wsPort);
    }

    public Integer getPort() {
        return this.port.get();
    }

    public void setSecurePort(int wssPort) {
        this.securePort.set(wssPort);
    }

    public Integer getSecurePort() {
        return this.securePort.get();
    }

    public void setAsynchronousPush(boolean asynchronousPush) {
        this.asynchronousPush = asynchronousPush;
    }

    public boolean isAsynchronousPush() {
        return this.asynchronousPush;
    }

    public void setAsynchronousPushTimeout(long asynchronousPushTimeout) {
        this.asynchronousPushTimeout = asynchronousPushTimeout;
    }

    public long getAsynchronousPushTimeout() {
        return this.asynchronousPushTimeout;
    }

    public static class ThreadFactory
    implements java.util.concurrent.ThreadFactory {
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Wicket-WebSocket-HttpRequest-Thread-" + this.counter.getAndIncrement());
        }
    }

    public static class WebSocketPushMessageExecutor
    implements Executor {
        private final java.util.concurrent.Executor nonHttpRequestExecutor;
        private final java.util.concurrent.Executor httpRequestExecutor;

        public WebSocketPushMessageExecutor() {
            this(Runnable::run, new ThreadPoolExecutor(1, 8, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory()));
        }

        public WebSocketPushMessageExecutor(java.util.concurrent.Executor nonHttpRequestExecutor, java.util.concurrent.Executor httpRequestExecutor) {
            this.nonHttpRequestExecutor = nonHttpRequestExecutor;
            this.httpRequestExecutor = httpRequestExecutor;
        }

        @Override
        public void run(Runnable command) {
            if (RequestCycle.get() != null) {
                this.httpRequestExecutor.execute(command);
            } else {
                this.nonHttpRequestExecutor.execute(command);
            }
        }
    }

    public static class SameThreadExecutor
    implements Executor {
        @Override
        public void run(Runnable command) {
            command.run();
        }
    }

    public static final class Holder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WebSocketSettings get(Application application) {
            WebSocketSettings settings = (WebSocketSettings)application.getMetaData(KEY);
            if (settings == null) {
                Application application2 = application;
                synchronized (application2) {
                    settings = (WebSocketSettings)application.getMetaData(KEY);
                    if (settings == null) {
                        settings = new WebSocketSettings();
                        Holder.set(application, settings);
                    }
                }
            }
            return settings;
        }

        public static void set(Application application, WebSocketSettings settings) {
            application.setMetaData(KEY, (Object)settings);
        }
    }
}

