/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.util.Iterator;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class UrlPathPageParametersEncoder
implements IPageParametersEncoder {
    @Override
    public Url encodePageParameters(PageParameters params) {
        Args.notNull(params, "params");
        Args.isTrue(params.getIndexedCount() == 0, "This encoder does not support indexed page parameters. Specified parameters: %s", params);
        Url url = new Url();
        for (INamedParameters.NamedPair pair : params.getAllNamed()) {
            url.getSegments().add(pair.getKey());
            url.getSegments().add(pair.getValue());
        }
        return url;
    }

    @Override
    public PageParameters decodePageParameters(Url url) {
        PageParameters params = new PageParameters();
        Iterator<String> segment = url.getSegments().iterator();
        while (segment.hasNext()) {
            String key = segment.next();
            if (Strings.isEmpty(key) || !segment.hasNext()) continue;
            String value = segment.next();
            params.add(key, value, INamedParameters.Type.PATH);
        }
        return params.isEmpty() ? null : params;
    }
}

